"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerExecuteRoute = registerExecuteRoute;
var _configSchema = require("@kbn/config-schema");
var _ = require("..");
var _enrich_policies = require("../../../lib/enrich_policies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const paramsSchema = _configSchema.schema.object({
  name: _configSchema.schema.string()
});
function registerExecuteRoute({
  router,
  lib: {
    handleEsError
  }
}) {
  router.put({
    path: (0, _.addInternalBasePath)('/enrich_policies/{name}'),
    validate: {
      params: paramsSchema
    }
  }, async (context, request, response) => {
    const {
      name
    } = request.params;
    const client = (await context.core).elasticsearch.client;
    try {
      const res = await _enrich_policies.enrichPoliciesActions.execute(client, name);
      return response.ok({
        body: res
      });
    } catch (error) {
      return handleEsError({
        error,
        response
      });
    }
  });
}