"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SemanticTextBanner = SemanticTextBanner;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultLicenseMessage = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.idxMgmt.indexDetails.mappings.semanticTextBanner.descriptionForPlatinumLicense",
  defaultMessage: "{label} Upgrade your license to add semantic_text field types to your indices.'",
  values: {
    label: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.mappings.semanticTextBanner.semanticTextFieldAvailableForPlatinumLicense",
      defaultMessage: "Semantic text now available for platinum license."
    }))
  }
});
const platinumLicenseMessage = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.idxMgmt.indexDetails.mappings.semanticTextBanner.description",
  defaultMessage: "{label} Add a field to your mapping and choose 'semantic_text' to get started.'",
  values: {
    label: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.mappings.semanticTextBanner.semanticTextFieldAvailable",
      defaultMessage: "semantic_text field type now available!"
    }))
  }
});
function SemanticTextBanner({
  isSemanticTextEnabled,
  isPlatinumLicense = false
}) {
  const [isSemanticTextBannerDisplayable, setIsSemanticTextBannerDisplayable] = (0, _useLocalStorage.default)('semantic-text-banner-display', true);
  return isSemanticTextBannerDisplayable && isSemanticTextEnabled ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "success",
    "data-test-subj": "indexDetailsMappingsSemanticTextBanner"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    color: "success"
  }, isPlatinumLicense ? platinumLicenseMessage : defaultLicenseMessage)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    onClick: () => setIsSemanticTextBannerDisplayable(false),
    "data-test-subj": "SemanticTextBannerDismissButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.indexDetails.mappings.semanticTextBanner.dismiss",
    defaultMessage: "Dismiss"
  })))))) : null;
}