"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PoliciesTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _app_context = require("../../../../app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const pagination = {
  initialPageSize: 50,
  pageSizeOptions: [25, 50, 100]
};
const PoliciesTable = ({
  policies,
  onReloadClick,
  onDeletePolicyClick,
  onExecutePolicyClick
}) => {
  const {
    history
  } = (0, _app_context.useAppContext)();
  const renderToolsRight = () => {
    return [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      key: "reloadPolicies",
      "data-test-subj": "reloadPoliciesButton",
      iconType: "refresh",
      color: "success",
      onClick: onReloadClick
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.enrichPolicies.table.reloadButton",
      defaultMessage: "Reload"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
      key: "createPolicy",
      fill: true,
      iconType: "plusInCircle"
    }, (0, _public.reactRouterNavigate)(history, '/enrich_policies/create')), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.enrichPolicies.table.createPolicyButton",
      defaultMessage: "Create enrich policy"
    }))];
  };
  const search = {
    toolsRight: renderToolsRight(),
    box: {
      incremental: true
    }
  };
  const columns = [{
    field: 'name',
    name: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.table.nameField', {
      defaultMessage: 'Name'
    }),
    sortable: true,
    truncateText: true,
    render: name => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
      "data-test-subj": "enrichPolicyDetailsLink"
    }, (0, _public.reactRouterNavigate)(history, {
      pathname: '/enrich_policies',
      search: `policy=${encodeURIComponent(name)}`
    })), name)
  }, {
    field: 'type',
    name: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.table.typeField', {
      defaultMessage: 'Type'
    }),
    sortable: true
  }, {
    field: 'sourceIndices',
    name: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.table.sourceIndicesField', {
      defaultMessage: 'Source indices'
    }),
    truncateText: true,
    render: indices => /*#__PURE__*/_react.default.createElement("span", {
      className: "eui-textTruncate"
    }, indices.join(', '))
  }, {
    field: 'matchField',
    name: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.table.matchFieldField', {
      defaultMessage: 'Match field'
    }),
    truncateText: true
  }, {
    field: 'enrichFields',
    name: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.table.enrichFieldsField', {
      defaultMessage: 'Enrich fields'
    }),
    truncateText: true,
    render: fields => /*#__PURE__*/_react.default.createElement("span", {
      className: "eui-textTruncate"
    }, fields.join(', '))
  }, {
    name: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.table.actionsField', {
      defaultMessage: 'Actions'
    }),
    actions: [{
      isPrimary: true,
      name: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.table.executeAction', {
        defaultMessage: 'Execute'
      }),
      description: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.table.executeDescription', {
        defaultMessage: 'Execute this enrich policy'
      }),
      type: 'icon',
      icon: 'play',
      'data-test-subj': 'executePolicyButton',
      onClick: ({
        name
      }) => onExecutePolicyClick(name)
    }, {
      isPrimary: true,
      name: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.table.deleteAction', {
        defaultMessage: 'Delete'
      }),
      description: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.table.deleteDescription', {
        defaultMessage: 'Delete this enrich policy'
      }),
      type: 'icon',
      icon: 'trash',
      color: 'danger',
      'data-test-subj': 'deletePolicyButton',
      onClick: ({
        name
      }) => onDeletePolicyClick(name)
    }]
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    "data-test-subj": "enrichPoliciesTable",
    items: policies,
    itemId: "name",
    columns: columns,
    search: search,
    pagination: pagination,
    sorting: true
  });
};
exports.PoliciesTable = PoliciesTable;