"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useKibana = exports.renderApp = exports.IndexManagementAppContext = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _reactDom = require("react-dom");
var _common = require("../../common");
var _shared_imports = require("../shared_imports");
var _app_context = require("./app_context");
var _app = require("./app");
var _store = require("./store");
var _components = require("./components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  GlobalFlyoutProvider
} = _shared_imports.GlobalFlyout;
const IndexManagementAppContext = ({
  children,
  core,
  dependencies
}) => {
  const {
    docLinks,
    notifications,
    application,
    executionContext,
    overlays,
    analytics,
    i18n,
    theme
  } = core;
  const startServices = {
    analytics,
    i18n,
    overlays,
    theme
  };
  const {
    services,
    setBreadcrumbs,
    uiSettings,
    settings,
    kibanaVersion
  } = dependencies;

  // theme is required by the CodeEditor component used to edit runtime field Painless scripts.
  const {
    Provider: KibanaReactContextProvider
  } = (0, _shared_imports.createKibanaReactContext)({
    application,
    uiSettings,
    settings,
    kibanaVersion: {
      get: () => kibanaVersion
    },
    theme
  });
  const componentTemplateProviderValues = {
    httpClient: services.httpService.httpClient,
    overlays,
    apiBasePath: _common.API_BASE_PATH,
    trackMetric: services.uiMetricService.trackMetric.bind(services.uiMetricService),
    docLinks,
    toasts: notifications.toasts,
    setBreadcrumbs,
    getUrlForApp: application.getUrlForApp,
    executionContext,
    startServices
  };
  return /*#__PURE__*/_react.default.createElement(_shared_imports.KibanaRenderContextProvider, core, /*#__PURE__*/_react.default.createElement(KibanaReactContextProvider, null, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: (0, _store.indexManagementStore)(services)
  }, /*#__PURE__*/_react.default.createElement(_app_context.AppContextProvider, {
    value: {
      ...dependencies,
      overlays
    }
  }, /*#__PURE__*/_react.default.createElement(_components.MappingsEditorProvider, null, /*#__PURE__*/_react.default.createElement(_components.ComponentTemplatesProvider, {
    value: componentTemplateProviderValues
  }, /*#__PURE__*/_react.default.createElement(GlobalFlyoutProvider, null, children)))))));
};
exports.IndexManagementAppContext = IndexManagementAppContext;
const renderApp = (elem, {
  core,
  dependencies
}) => {
  if (!elem) {
    return () => undefined;
  }
  const {
    history
  } = dependencies;
  (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(IndexManagementAppContext, {
    core: core,
    dependencies: dependencies
  }, /*#__PURE__*/_react.default.createElement(_app.App, {
    history: history
  })), elem);
  return () => {
    (0, _reactDom.unmountComponentAtNode)(elem);
  };
};
exports.renderApp = renderApp;
// We override useKibana() from the react plugin to return a typed version for this app
const useKibana = () => {
  return (0, _shared_imports.useKibana)();
};
exports.useKibana = useKibana;