"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIndexErrors = void 0;
var _i18n = require("@kbn/i18n");
var _react = require("react");
var _lib = require("../components/mappings_editor/lib");
var _utils = require("../components/mappings_editor/lib/utils");
var _services = require("../services");
var _parse_mappings = require("../shared/parse_mappings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIndexErrors = (index, ml, canGetTrainedModels) => {
  var _ml$mlApi2;
  const {
    data
  } = (0, _services.useLoadIndexMappings)(index.name);
  const {
    data: endpoints
  } = (0, _services.useLoadInferenceEndpoints)();
  const [errors, setErrors] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    var _parsedMappings$parse;
    const mappings = data;
    if (!mappings || !canGetTrainedModels || !endpoints || !ml) {
      return;
    }
    const parsedMappings = (0, _parse_mappings.parseMappings)(mappings);
    const normalizedFields = (0, _lib.normalize)((_parsedMappings$parse = parsedMappings.parsedDefaultValue) === null || _parsedMappings$parse === void 0 ? void 0 : _parsedMappings$parse.fields);
    const semanticTextFields = Object.values(normalizedFields.byId).filter(field => field.source.type === 'semantic_text');
    const fetchErrors = async () => {
      var _ml$mlApi;
      const trainedModelStats = await ((_ml$mlApi = ml.mlApi) === null || _ml$mlApi === void 0 ? void 0 : _ml$mlApi.trainedModels.getTrainedModelStats());
      const semanticTextFieldsWithErrors = semanticTextFields.map(field => {
        const model = endpoints.find(endpoint => endpoint.inference_id === field.source.inference_id);
        if (!model) {
          return {
            field,
            error: _i18n.i18n.translate('xpack.idxMgmt.indexOverview.indexErrors.missingModelError', {
              defaultMessage: 'Model not found for inference endpoint {inferenceId}',
              values: {
                inferenceId: field.source.inference_id
              }
            })
          };
        }
        if ((0, _utils.isLocalModel)(model)) {
          var _modelStats$deploymen;
          const modelId = model.service_settings.model_id;
          const modelStats = trainedModelStats === null || trainedModelStats === void 0 ? void 0 : trainedModelStats.trained_model_stats.find(value => value.model_id === modelId);
          if (!modelStats || ((_modelStats$deploymen = modelStats.deployment_stats) === null || _modelStats$deploymen === void 0 ? void 0 : _modelStats$deploymen.state) !== 'started') {
            return {
              field,
              error: _i18n.i18n.translate('xpack.idxMgmt.indexOverview.indexErrors.modelNotStartedError', {
                defaultMessage: 'Model {modelId} for inference endpoint {inferenceId} in field {fieldName} has not been started',
                values: {
                  inferenceId: field.source.inference_id,
                  fieldName: field.path.join('.'),
                  modelId
                }
              })
            };
          }
        }
        return {
          field,
          error: ''
        };
      }).filter(value => !!value.error);
      setErrors(semanticTextFieldsWithErrors);
    };
    if (semanticTextFields.length) {
      fetchErrors();
    }
  }, [data, canGetTrainedModels, endpoints, ml, ml === null || ml === void 0 ? void 0 : (_ml$mlApi2 = ml.mlApi) === null || _ml$mlApi2 === void 0 ? void 0 : _ml$mlApi2.trainedModels]);
  return errors;
};
exports.useIndexErrors = useIndexErrors;