"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TemplateDeleteModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _api = require("../services/api");
var _notification = require("../services/notification");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TemplateDeleteModal = ({
  templatesToDelete,
  callback
}) => {
  const [isDeleteConfirmed, setIsDeleteConfirmed] = (0, _react.useState)(false);
  const numTemplatesToDelete = templatesToDelete.length;
  const hasSystemTemplate = Boolean(templatesToDelete.find(({
    name
  }) => name.startsWith('.')));
  const handleDeleteTemplates = () => {
    (0, _api.deleteTemplates)(templatesToDelete).then(({
      data: {
        templatesDeleted,
        errors
      },
      error
    }) => {
      const hasDeletedTemplates = templatesDeleted && templatesDeleted.length;
      if (hasDeletedTemplates) {
        const successMessage = templatesDeleted.length === 1 ? _i18n.i18n.translate('xpack.idxMgmt.deleteTemplatesModal.successDeleteSingleNotificationMessageText', {
          defaultMessage: "Deleted template ''{templateName}''",
          values: {
            templateName: templatesToDelete[0].name
          }
        }) : _i18n.i18n.translate('xpack.idxMgmt.deleteTemplatesModal.successDeleteMultipleNotificationMessageText', {
          defaultMessage: 'Deleted {numSuccesses, plural, one {# template} other {# templates}}',
          values: {
            numSuccesses: templatesDeleted.length
          }
        });
        callback({
          hasDeletedTemplates
        });
        _notification.notificationService.showSuccessToast(successMessage);
      }
      if (error || errors && errors.length) {
        const hasMultipleErrors = errors && errors.length > 1 || error && templatesToDelete.length > 1;
        const errorMessage = hasMultipleErrors ? _i18n.i18n.translate('xpack.idxMgmt.deleteTemplatesModal.multipleErrorsNotificationMessageText', {
          defaultMessage: 'Error deleting {count} templates',
          values: {
            count: errors && errors.length || templatesToDelete.length
          }
        }) : _i18n.i18n.translate('xpack.idxMgmt.deleteTemplatesModal.errorNotificationMessageText', {
          defaultMessage: "Error deleting template ''{name}''",
          values: {
            name: errors && errors[0].name || templatesToDelete[0]
          }
        });
        _notification.notificationService.showDangerToast(errorMessage);
      }
    });
  };
  const handleOnCancel = () => {
    setIsDeleteConfirmed(false);
    callback();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    buttonColor: "danger",
    "data-test-subj": "deleteTemplatesConfirmation",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.deleteTemplatesModal.modalTitleText",
      defaultMessage: "Delete {numTemplatesToDelete, plural, one {template} other {# templates}}",
      values: {
        numTemplatesToDelete
      }
    }),
    onCancel: handleOnCancel,
    onConfirm: handleDeleteTemplates,
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.deleteTemplatesModal.cancelButtonLabel",
      defaultMessage: "Cancel"
    }),
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.deleteTemplatesModal.confirmButtonLabel",
      defaultMessage: "Delete {numTemplatesToDelete, plural, one {template} other {templates} }",
      values: {
        numTemplatesToDelete
      }
    }),
    confirmButtonDisabled: hasSystemTemplate ? !isDeleteConfirmed : false
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.deleteTemplatesModal.deleteDescription",
    defaultMessage: "You are about to delete {numTemplatesToDelete, plural, one {this template} other {these templates} }:",
    values: {
      numTemplatesToDelete
    }
  })), /*#__PURE__*/_react.default.createElement("ul", null, templatesToDelete.map(({
    name
  }) => /*#__PURE__*/_react.default.createElement("li", {
    key: name
  }, name, name.startsWith('.') ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    iconType: "warning",
    color: "hollow"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.deleteTemplatesModal.systemTemplateLabel",
    defaultMessage: "System template"
  }))) : null))), hasSystemTemplate && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.deleteTemplatesModal.proceedWithCautionCallOutTitle",
      defaultMessage: "Deleting a system template can break Kibana"
    }),
    color: "danger",
    iconType: "warning",
    "data-test-subj": "deleteSystemTemplateCallOut"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.deleteTemplatesModal.proceedWithCautionCallOutDescription",
    defaultMessage: "System templates are critical for internal operations. If you delete this template, you can\u2019t recover it."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "confirmDeleteTemplatesCheckbox",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.deleteTemplatesModal.confirmDeleteCheckboxLabel",
      defaultMessage: "I understand the consequences of deleting a system template"
    }),
    checked: isDeleteConfirmed,
    onChange: e => setIsDeleteConfirmed(e.target.checked)
  }))));
};
exports.TemplateDeleteModal = TemplateDeleteModal;