"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepMappingsContainer = void 0;
var _react = _interopRequireDefault(require("react"));
var _shared_imports = require("../../../../../shared_imports");
var _services = require("../../../../services");
var _step_mappings = require("./step_mappings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StepMappingsContainer = ({
  esDocsBase
}) => {
  const {
    defaultValue,
    updateContent,
    getSingleContentData
  } = _shared_imports.Forms.useContent('mappings');
  const {
    data: esNodesPlugins
  } = (0, _services.useLoadNodesPlugins)();
  return /*#__PURE__*/_react.default.createElement(_step_mappings.StepMappings, {
    defaultValue: defaultValue,
    onChange: updateContent,
    indexSettings: getSingleContentData('settings'),
    esDocsBase: esDocsBase,
    esNodesPlugins: esNodesPlugins !== null && esNodesPlugins !== void 0 ? esNodesPlugins : []
  });
};
exports.StepMappingsContainer = StepMappingsContainer;