"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateField = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../constants");
var _lib = require("../../../../lib");
var _utils = require("../../../../lib/utils");
var _mappings_state_context = require("../../../../mappings_state_context");
var _shared_imports = require("../../../../shared_imports");
var _field_parameters = require("../../field_parameters");
var _reference_field_selects = require("../../field_parameters/reference_field_selects");
var _select_inference_id = require("../../field_parameters/select_inference_id");
var _field_beta_badge = require("../field_beta_badge");
var _required_parameters_forms = require("./required_parameters_forms");
var _use_semantic_text = require("./semantic_text/use_semantic_text");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formWrapper = props => /*#__PURE__*/_react.default.createElement("form", props);
const CreateField = exports.CreateField = /*#__PURE__*/_react.default.memo(function CreateFieldComponent({
  allFields,
  isRootLevelField,
  isMultiField,
  paddingLeft,
  isCancelable,
  maxNestedDepth,
  onCancelAddingNewFields,
  isAddingFields,
  semanticTextInfo
}) {
  const {
    isSemanticTextEnabled,
    ml,
    setErrorsInTrainedModelDeployment
  } = semanticTextInfo !== null && semanticTextInfo !== void 0 ? semanticTextInfo : {};
  const dispatch = (0, _mappings_state_context.useDispatch)();
  const {
    form
  } = (0, _shared_imports.useForm)({
    serializer: _lib.fieldSerializer,
    options: {
      stripEmptyFields: false
    },
    id: 'create-field'
  });
  (0, _shared_imports.useFormData)({
    form
  });
  const {
    subscribe
  } = form;
  (0, _react.useEffect)(() => {
    const subscription = subscribe(updatedFieldForm => {
      dispatch({
        type: 'fieldForm.update',
        value: updatedFieldForm
      });
    });
    return subscription.unsubscribe;
  }, [dispatch, subscribe]);
  const cancel = () => {
    if (isAddingFields && onCancelAddingNewFields) {
      onCancelAddingNewFields();
    } else {
      dispatch({
        type: 'documentField.changeStatus',
        value: 'idle'
      });
    }
  };
  const {
    createInferenceEndpoint,
    handleSemanticText
  } = (0, _use_semantic_text.useSemanticText)({
    form,
    setErrorsInTrainedModelDeployment,
    ml
  });
  const isSemanticText = form.getFormData().type === 'semantic_text';
  const submitForm = async (e, exitAfter = false, clickOutside = false) => {
    if (e) {
      e.preventDefault();
    }
    const {
      isValid,
      data
    } = await form.submit();
    if (isValid && !clickOutside) {
      if ((0, _utils.isSemanticTextField)(data)) {
        handleSemanticText(data);
      } else {
        dispatch({
          type: 'field.add',
          value: data
        });
      }
      if (exitAfter) {
        cancel();
      }
      form.reset();
    }
  };
  const onClickOutside = () => {
    const name = form.getFields().name.value;
    if (name.trim() === '') {
      if (isCancelable !== false) {
        cancel();
      }
    } else {
      submitForm(undefined, true, true);
    }
  };
  const renderFormFields = () => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_field_parameters.TypeParameter, {
    isRootLevelField: isRootLevelField,
    isMultiField: isMultiField,
    showDocLink: true,
    isSemanticTextEnabled: isSemanticTextEnabled
  })), /*#__PURE__*/_react.default.createElement(_shared_imports.FormDataProvider, {
    pathsToWatch: "type"
  }, ({
    type
  }) => {
    if (type === undefined) {
      return null;
    }
    const [fieldType] = type;
    return /*#__PURE__*/_react.default.createElement(_field_parameters.SubTypeParameter, {
      key: fieldType === null || fieldType === void 0 ? void 0 : fieldType.value,
      type: fieldType === null || fieldType === void 0 ? void 0 : fieldType.value,
      isMultiField: isMultiField !== null && isMultiField !== void 0 ? isMultiField : false,
      isRootLevelField: isRootLevelField
    });
  }), isSemanticText && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_reference_field_selects.ReferenceFieldSelects, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_field_parameters.NameParameter, {
    isSemanticText: isSemanticText
  })));
  const renderFormActions = () => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexEnd"
  }, (isCancelable !== false || isAddingFields) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: cancel,
    "data-test-subj": "cancelButton"
  }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.createField.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    onClick: submitForm,
    type: "submit",
    "data-test-subj": "addButton",
    isDisabled: form.getErrors().length > 0
  }, isMultiField ? _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.createField.addMultiFieldButtonLabel', {
    defaultMessage: 'Add multi-field'
  }) : _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.createField.addFieldButtonLabel', {
    defaultMessage: 'Add field'
  }))));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiOutsideClickDetector, {
    onOutsideClick: onClickOutside
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    FormWrapper: formWrapper,
    onSubmit: submitForm,
    "data-test-subj": "createFieldForm"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('mappingsEditor__createFieldWrapper', {
      'mappingsEditor__createFieldWrapper--toggle': Boolean(maxNestedDepth) && maxNestedDepth > 0,
      'mappingsEditor__createFieldWrapper--multiField': isMultiField
    }),
    style: {
      paddingLeft: `${isMultiField ? paddingLeft - _constants.EUI_SIZE * 1.5 // As there are no "L" bullet list we need to substract some indent
      : paddingLeft}px`
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "mappingsEditor__createFieldContent"
  }, renderFormFields(), /*#__PURE__*/_react.default.createElement(_shared_imports.FormDataProvider, {
    pathsToWatch: ['type', 'subType']
  }, ({
    type,
    subType
  }) => {
    var _type$, _subType$;
    const RequiredParametersForm = (0, _required_parameters_forms.getRequiredParametersFormForType)(type === null || type === void 0 ? void 0 : (_type$ = type[0]) === null || _type$ === void 0 ? void 0 : _type$.value, subType === null || subType === void 0 ? void 0 : (_subType$ = subType[0]) === null || _subType$ === void 0 ? void 0 : _subType$.value);
    if (!RequiredParametersForm) {
      return null;
    }
    const typeDefinition = _constants.TYPE_DEFINITION[type === null || type === void 0 ? void 0 : type[0].value];
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "mappingsEditor__createFieldRequiredProps"
    }, typeDefinition.isBeta ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_beta_badge.FieldBetaBadge, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    })) : null, /*#__PURE__*/_react.default.createElement(RequiredParametersForm, {
      key: subType !== null && subType !== void 0 ? subType : type,
      allFields: allFields
    }));
  }), isSemanticText && /*#__PURE__*/_react.default.createElement(_select_inference_id.SelectInferenceId, {
    createInferenceEndpoint: createInferenceEndpoint
  }), renderFormActions())))));
});