"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectInferenceId = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
var _inference_flyout_wrapper = require("@kbn/inference_integration_flyout/components/inference_flyout_wrapper");
var _lib = require("../../../lib");
var _app_context = require("../../../../../app_context");
var _api = require("../../../../../services/api");
var _use_ml_model_status_toasts = require("../../../../../../hooks/use_ml_model_status_toasts");
var _shared_imports = require("../../../shared_imports");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultEndpoints = [{
  inference_id: 'elser_model_2'
}, {
  inference_id: 'e5'
}];
const SelectInferenceId = ({
  createInferenceEndpoint,
  'data-test-subj': dataTestSubj
}) => {
  const config = (0, _lib.getFieldConfig)('inference_id');
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "inference_id",
    fieldConfig: config
  }, field => {
    return /*#__PURE__*/_react.default.createElement(SelectInferenceIdContent, {
      createInferenceEndpoint: createInferenceEndpoint,
      "data-test-subj": dataTestSubj,
      value: field.value,
      setValue: field.setValue
    });
  });
};
exports.SelectInferenceId = SelectInferenceId;
const SelectInferenceIdContent = ({
  createInferenceEndpoint,
  'data-test-subj': dataTestSubj,
  setValue,
  value
}) => {
  var _options$find;
  const {
    core: {
      application,
      http
    },
    docLinks,
    plugins: {
      ml
    }
  } = (0, _app_context.useAppContext)();
  const config = (0, _lib.getFieldConfig)('inference_id');
  const inferenceEndpointsPageLink = `${http.basePath.get()}/app/enterprise_search/relevance/inference_endpoints`;
  const [isInferenceFlyoutVisible, setIsInferenceFlyoutVisible] = (0, _react.useState)(false);
  const [availableTrainedModels, setAvailableTrainedModels] = (0, _react.useState)([]);
  const onFlyoutClose = (0, _react.useCallback)(() => {
    setIsInferenceFlyoutVisible(!isInferenceFlyoutVisible);
  }, [isInferenceFlyoutVisible]);
  (0, _react.useEffect)(() => {
    const fetchAvailableTrainedModels = async () => {
      var _await$ml$mlApi$train, _ml$mlApi, _ml$mlApi$trainedMode;
      setAvailableTrainedModels((_await$ml$mlApi$train = await (ml === null || ml === void 0 ? void 0 : (_ml$mlApi = ml.mlApi) === null || _ml$mlApi === void 0 ? void 0 : (_ml$mlApi$trainedMode = _ml$mlApi.trainedModels) === null || _ml$mlApi$trainedMode === void 0 ? void 0 : _ml$mlApi$trainedMode.getTrainedModels())) !== null && _await$ml$mlApi$train !== void 0 ? _await$ml$mlApi$train : []);
    };
    fetchAvailableTrainedModels();
  }, [ml]);
  const trainedModels = (0, _react.useMemo)(() => {
    const availableTrainedModelsList = availableTrainedModels.filter(model => model.model_type === _mlTrainedModelsUtils.TRAINED_MODEL_TYPE.PYTORCH && (model !== null && model !== void 0 && model.inference_config ? Object.keys(model.inference_config).includes(_mlTrainedModelsUtils.SUPPORTED_PYTORCH_TASKS.TEXT_EMBEDDING) : {})).map(model => model.model_id);
    return availableTrainedModelsList;
  }, [availableTrainedModels]);
  const [isSaveInferenceLoading, setIsSaveInferenceLoading] = (0, _react.useState)(false);
  const {
    isLoading,
    data: endpoints,
    resendRequest
  } = (0, _api.useLoadInferenceEndpoints)();
  const options = (0, _react.useMemo)(() => {
    const filteredEndpoints = endpoints === null || endpoints === void 0 ? void 0 : endpoints.filter(endpoint => endpoint.task_type === 'text_embedding' || endpoint.task_type === 'sparse_embedding');
    const missingDefaultEndpoints = defaultEndpoints.filter(endpoint => !(filteredEndpoints || []).find(e => e.inference_id === endpoint.inference_id));
    const newOptions = [...(filteredEndpoints || []), ...missingDefaultEndpoints].map(endpoint => ({
      label: endpoint.inference_id,
      'data-test-subj': `custom-inference_${endpoint.inference_id}`,
      checked: value === endpoint.inference_id ? 'on' : undefined
    }));
    if (value && !newOptions.find(option => option.label === value)) {
      // Sometimes we create a new endpoint but the backend is slow in updating so we need to optimistically update
      const newOption = {
        label: value,
        checked: 'on',
        'data-test-subj': `custom-inference_${value}`
      };
      return [...newOptions, newOption];
    }
    return newOptions;
  }, [endpoints, value]);
  const {
    showErrorToasts
  } = (0, _use_ml_model_status_toasts.useMLModelNotificationToasts)();
  const onSaveInferenceCallback = (0, _react.useCallback)(async (inferenceId, taskType, modelConfig) => {
    try {
      const trainedModelId = modelConfig.service_settings.model_id || '';
      const customModelConfig = {
        taskType,
        modelConfig
      };
      setIsSaveInferenceLoading(true);
      await createInferenceEndpoint(trainedModelId, inferenceId, customModelConfig);
      resendRequest();
      setValue(inferenceId);
      setIsInferenceFlyoutVisible(!isInferenceFlyoutVisible);
      setIsSaveInferenceLoading(false);
    } catch (error) {
      showErrorToasts(error);
      setIsSaveInferenceLoading(false);
    }
  }, [createInferenceEndpoint, setValue, isInferenceFlyoutVisible, showErrorToasts, resendRequest]);
  const [isInferencePopoverVisible, setIsInferencePopoverVisible] = (0, _react.useState)(false);
  const [inferenceEndpointError, setInferenceEndpointError] = (0, _react.useState)(undefined);
  const onInferenceEndpointChange = (0, _react.useCallback)(async inferenceId => {
    const modelsExist = options.some(i => i.label === inferenceId);
    if (modelsExist) {
      setInferenceEndpointError(_i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.inferenceId.popover.defaultLabel', {
        defaultMessage: 'Inference endpoint {inferenceId} already exists',
        values: {
          inferenceId
        }
      }));
    } else {
      setInferenceEndpointError(undefined);
    }
  }, [options]);
  const selectedOptionLabel = (_options$find = options.find(option => option.checked)) === null || _options$find === void 0 ? void 0 : _options$find.label;
  const inferencePopover = () => /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("strong", null, config.label))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "arrowDown",
      iconSide: "right",
      color: "text",
      "data-test-subj": "inferenceIdButton",
      onClick: () => {
        setIsInferencePopoverVisible(!isInferencePopoverVisible);
      }
    }, selectedOptionLabel || _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.inferenceId.popover.alreadyExistsLabel', {
      defaultMessage: 'No inference endpoint selected'
    }))),
    isOpen: isInferencePopoverVisible,
    panelPaddingSize: "m",
    closePopover: () => setIsInferencePopoverVisible(!isInferencePopoverVisible)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "manageInferenceEndpointButton",
    icon: "gear",
    size: "s",
    "data-test-subj": "manageInferenceEndpointButton",
    onClick: async () => {
      application.navigateToUrl(inferenceEndpointsPageLink);
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.inferenceId.popover.manageInferenceEndpointButton', {
    defaultMessage: 'Manage Inference Endpoints'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.inferenceId.popover.selectable.Label', {
    defaultMessage: 'Existing endpoints'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "aria-label": _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.inferenceId.popover.selectable.ariaLabel', {
      defaultMessage: 'Existing endpoints'
    }),
    "data-test-subj": dataTestSubj,
    searchable: true,
    isLoading: isLoading,
    singleSelection: "always",
    searchProps: {
      compressed: true,
      placeholder: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.inferenceId.popover.selectable.placeholder', {
        defaultMessage: 'Search'
      })
    },
    options: options,
    onChange: newOptions => {
      var _newOptions$find;
      setValue(((_newOptions$find = newOptions.find(option => option.checked)) === null || _newOptions$find === void 0 ? void 0 : _newOptions$find.label) || '');
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search, list))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "help",
      color: "primary"
    }),
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.enterpriseSearch.inferenceApiCreate,
    target: "_blank",
    "data-test-subj": "learn-how-to-create-inference-endpoints"
  }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.learnHowToCreateInferenceEndpoints', {
    defaultMessage: 'Learn how to create inference endpoints'
  }))));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "selectInferenceId"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, inferencePopover(), isInferenceFlyoutVisible && /*#__PURE__*/_react.default.createElement(_inference_flyout_wrapper.InferenceFlyoutWrapper, {
    elserv2documentationUrl: docLinks.links.ml.nlpElser,
    e5documentationUrl: docLinks.links.ml.nlpE5,
    onInferenceEndpointChange: onInferenceEndpointChange,
    inferenceEndpointError: inferenceEndpointError,
    trainedModels: trainedModels,
    onSaveInferenceEndpoint: onSaveInferenceCallback,
    onFlyoutClose: onFlyoutClose,
    isInferenceFlyoutVisible: isInferenceFlyoutVisible,
    supportedNlpModels: docLinks.links.enterpriseSearch.supportedNlpModels,
    nlpImportModel: docLinks.links.ml.nlpImportModel,
    setInferenceEndpointError: setInferenceEndpointError,
    isCreateInferenceApiLoading: isSaveInferenceLoading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: "warning",
    title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.noReferenceModelStartWarningMessage', {
      defaultMessage: 'The referenced model for this inference endpoint will be started when adding this field.'
    })
  }))));
};