"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceFieldSection = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _documentation = require("../../../../../services/documentation");
var _shared_imports = require("../../../shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SourceFieldSection = () => {
  const renderWarning = () => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.disabledSourceFieldCallOutTitle', {
      defaultMessage: 'Use caution when disabling the _source field'
    }),
    iconType: "warning",
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.mappingsEditor.disabledSourceFieldCallOutDescription1",
    defaultMessage: "Disabling {source} lowers storage overhead within the index, but this comes at a cost. It also disables important features, such as the ability to reindex or debug queries by viewing the original document.",
    values: {
      source: /*#__PURE__*/_react.default.createElement("code", null, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.disabledSourceFieldCallOutDescription1.sourceText', {
        defaultMessage: '_source'
      }))
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("a", {
    href: _documentation.documentationService.getDisablingMappingSourceFieldLink(),
    target: "_blank",
    rel: "noopener noreferrer"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.mappingsEditor.disabledSourceFieldCallOutDescription2",
    defaultMessage: "Learn more about alternatives to disabling the {source} field.",
    values: {
      source: /*#__PURE__*/_react.default.createElement("code", null, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.disabledSourceFieldCallOutDescription2.sourceText', {
        defaultMessage: '_source'
      }))
    }
  }))));
  const renderFormFields = () => /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "sourceField"
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "sourceField.includes"
  }, ({
    label,
    helpText,
    value,
    setValue
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    helpText: helpText,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    noSuggestions: true,
    placeholder: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.sourceIncludeField.placeholderLabel', {
      defaultMessage: 'path.to.field.*'
    }),
    selectedOptions: value,
    onChange: newValue => {
      setValue(newValue);
    },
    onCreateOption: searchValue => {
      const newOption = {
        label: searchValue
      };
      setValue([...value, newOption]);
    },
    fullWidth: true,
    "data-test-subj": "includesField"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "sourceField.excludes"
  }, ({
    label,
    helpText,
    value,
    setValue
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    helpText: helpText,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    noSuggestions: true,
    placeholder: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.sourceExcludeField.placeholderLabel', {
      defaultMessage: 'path.to.field.*'
    }),
    selectedOptions: value,
    onChange: newValue => {
      setValue(newValue);
    },
    onCreateOption: searchValue => {
      const newOption = {
        label: searchValue
      };
      setValue([...value, newOption]);
    },
    fullWidth: true,
    "data-test-subj": "excludesField"
  }))));
  return /*#__PURE__*/_react.default.createElement(_shared_imports.FormRow, {
    title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.sourceFieldTitle', {
      defaultMessage: '_source field'
    }),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.sourceFieldDescription",
      defaultMessage: "The _source field contains the original JSON document body that was provided at index time. Individual fields can be pruned by defining which ones to include or exclude from the _source field. {docsLink}",
      values: {
        docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _documentation.documentationService.getMappingSourceFieldLink(),
          target: "_blank"
        }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.sourceFieldDocumentionLink', {
          defaultMessage: 'Learn more.'
        }))
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
      path: "sourceField.enabled",
      component: _shared_imports.ToggleField
    }))
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.FormDataProvider, {
    pathsToWatch: ['sourceField.enabled']
  }, formData => {
    const {
      sourceField: {
        enabled
      }
    } = formData;
    if (enabled === undefined) {
      return null;
    }
    return enabled ? renderFormFields() : renderWarning();
  }));
};
exports.SourceFieldSection = SourceFieldSection;