"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComponentTemplateCreate = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _redirect_path = require("../../../../hooks/redirect_path");
var _breadcrumbs = require("../../../../services/breadcrumbs");
var _component_templates_context = require("../../component_templates_context");
var _component_template_form = require("../component_template_form");
var _use_step_from_query_string = require("../use_step_from_query_string");
var _use_datastreams_rollover = require("../component_template_datastreams_rollover/use_datastreams_rollover");
var _constants = require("../../constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ComponentTemplateCreate = ({
  history,
  sourceComponentTemplate
}) => {
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const [saveError, setSaveError] = (0, _react.useState)(null);
  const redirectTo = (0, _redirect_path.useRedirectPath)(history);
  const {
    activeStep: defaultActiveStep,
    updateStep
  } = (0, _use_step_from_query_string.useStepFromQueryString)(history);
  const locationSearchParams = (0, _react.useMemo)(() => {
    return new URLSearchParams(history.location.search);
  }, [history.location.search]);
  const defaultValue = (0, _react.useMemo)(() => {
    var _locationSearchParams;
    if (sourceComponentTemplate) {
      return sourceComponentTemplate;
    }
    const name = (_locationSearchParams = locationSearchParams.get('name')) !== null && _locationSearchParams !== void 0 ? _locationSearchParams : '';
    const managedBy = locationSearchParams.get('managed_by');
    return {
      name,
      template: {},
      _meta: managedBy ? {
        managed_by: managedBy
      } : {},
      _kbnMeta: {
        usedBy: [],
        isManaged: false
      }
    };
  }, [locationSearchParams, sourceComponentTemplate]);
  const {
    api
  } = (0, _component_templates_context.useComponentTemplatesContext)();
  const {
    showDatastreamRolloverModal
  } = (0, _use_datastreams_rollover.useDatastreamsRollover)();
  const onSave = async componentTemplate => {
    var _componentTemplate$_m;
    const {
      name
    } = componentTemplate;
    setIsSaving(true);
    setSaveError(null);
    const {
      error
    } = await api.createComponentTemplate(componentTemplate);
    setIsSaving(false);
    if (error) {
      setSaveError(error);
      return;
    }
    if (((_componentTemplate$_m = componentTemplate._meta) === null || _componentTemplate$_m === void 0 ? void 0 : _componentTemplate$_m.managed_by) === _constants.MANAGED_BY_FLEET) {
      await showDatastreamRolloverModal(componentTemplate.name);
    }
    redirectTo(encodeURI(`/component_templates/${encodeURIComponent(name)}`));
  };
  const clearSaveError = () => {
    setSaveError(null);
  };
  const isCloning = Boolean(sourceComponentTemplate);
  (0, _react.useEffect)(() => {
    if (isCloning) {
      _breadcrumbs.breadcrumbService.setBreadcrumbs(_breadcrumbs.IndexManagementBreadcrumb.componentTemplateClone);
    } else {
      _breadcrumbs.breadcrumbService.setBreadcrumbs(_breadcrumbs.IndexManagementBreadcrumb.componentTemplateCreate);
    }
  }, [isCloning]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    restrictWidth: true,
    style: {
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "pageTitle"
    }, isCloning ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.cloneComponentTemplate.pageTitle",
      defaultMessage: "Clone component template"
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.createComponentTemplate.pageTitle",
      defaultMessage: "Create component template"
    })),
    bottomBorder: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_component_template_form.ComponentTemplateForm, {
    defaultActiveWizardSection: defaultActiveStep,
    onStepChange: updateStep,
    defaultValue: defaultValue,
    onSave: onSave,
    isSaving: isSaving,
    saveError: saveError,
    clearSaveError: clearSaveError
  }));
};
exports.ComponentTemplateCreate = ComponentTemplateCreate;