"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _analytics = require("@kbn/analytics");
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _settings_local_storage = require("../../../lib/settings_local_storage");
var _shared_imports = require("../../../../shared_imports");
var _navigation = require("../../../services/navigation");
var _ui_metric = require("../../../services/ui_metric");
var _constants = require("../../../constants");
var _policies = require("../../../lib/policies");
var _policy_list_context = require("../policy_list_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const actionTooltips = {
  deleteEnabled: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.deletePolicyButtonText', {
    defaultMessage: 'Delete policy'
  }),
  deleteDisabled: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.deletePolicyButtonDisabledTooltip', {
    defaultMessage: 'You cannot delete a policy that is being used by an index'
  }),
  viewIndices: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.viewIndicesButtonText', {
    defaultMessage: 'View indices linked to policy'
  }),
  addIndexTemplate: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.addPolicyToTemplateButtonText', {
    defaultMessage: 'Add policy to index template'
  })
};
const managedPolicyTooltips = {
  badge: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.templateBadgeType.managedLabel', {
    defaultMessage: 'Managed'
  }),
  badgeTooltip: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.templateBadgeType.managedDescription', {
    defaultMessage: 'This policy is preconfigured and managed by Elastic; editing or deleting this policy might break Kibana.'
  })
};
const deprecatedPolicyTooltips = {
  badge: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.templateBadgeType.deprecatedLabel', {
    defaultMessage: 'Deprecated'
  }),
  badgeTooltip: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.templateBadgeType.deprecatedDescription', {
    defaultMessage: 'This policy is no longer supported and might be removed in a future release. Instead, use one of the other policies available or create a new one.'
  })
};
const SHOW_MANAGED_POLICIES_BY_DEFAULT = 'ILM_SHOW_MANAGED_POLICIES_BY_DEFAULT';
const PolicyTable = ({
  policies
}) => {
  const [query, setQuery] = (0, _react.useState)('');
  const history = (0, _reactRouterDom.useHistory)();
  const {
    services: {
      getUrlForApp
    }
  } = (0, _shared_imports.useKibana)();
  const [managedPoliciesVisible, setManagedPoliciesVisible] = (0, _settings_local_storage.useStateWithLocalStorage)(SHOW_MANAGED_POLICIES_BY_DEFAULT, false);
  const {
    setListAction
  } = (0, _policy_list_context.usePolicyListContext)();
  const handleOnChange = ({
    queryText,
    error
  }) => {
    if (!error) {
      setQuery(queryText);
    }
  };
  const searchOptions = (0, _react.useMemo)(() => ({
    query,
    onChange: handleOnChange,
    box: {
      incremental: true,
      'data-test-subj': 'ilmSearchBar'
    },
    filters: [{
      type: 'is',
      field: 'policy.deprecated',
      name: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.isDeprecatedFilterLabel', {
        defaultMessage: 'Deprecated'
      })
    }],
    toolsRight: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      id: "checkboxShowHiddenIndices",
      "data-test-subj": "includeHiddenPoliciesSwitch",
      checked: managedPoliciesVisible,
      onChange: event => setManagedPoliciesVisible(event.target.checked),
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.policyTable.hiddenPoliciesSwitchLabel",
        defaultMessage: "Include managed system policies"
      })
    }))
  }), [managedPoliciesVisible, setManagedPoliciesVisible, query]);
  const filteredPolicies = (0, _react.useMemo)(() => {
    let result = managedPoliciesVisible ? policies : policies.filter(item => {
      var _item$policy, _item$policy$_meta;
      return !((_item$policy = item.policy) !== null && _item$policy !== void 0 && (_item$policy$_meta = _item$policy._meta) !== null && _item$policy$_meta !== void 0 && _item$policy$_meta.managed);
    });

    // When the query includes 'is:policy.deprecated', we want to show deprecated policies.
    // Otherwise hide them all since they wont be supported in the future.
    if (query.includes('is:policy.deprecated')) {
      result = result.filter(item => {
        var _item$policy2;
        return (_item$policy2 = item.policy) === null || _item$policy2 === void 0 ? void 0 : _item$policy2.deprecated;
      });
    } else {
      result = result.filter(item => {
        var _item$policy3;
        return !((_item$policy3 = item.policy) !== null && _item$policy3 !== void 0 && _item$policy3.deprecated);
      });
    }
    return result;
  }, [policies, managedPoliciesVisible, query]);
  const columns = [{
    'data-test-subj': 'policy-name',
    field: 'name',
    name: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.headers.nameHeader', {
      defaultMessage: 'Name'
    }),
    sortable: true,
    render: (value, item) => {
      var _item$policy4, _item$policy4$_meta, _item$policy5;
      const isManaged = (_item$policy4 = item.policy) === null || _item$policy4 === void 0 ? void 0 : (_item$policy4$_meta = _item$policy4._meta) === null || _item$policy4$_meta === void 0 ? void 0 : _item$policy4$_meta.managed;
      const isDeprecated = (_item$policy5 = item.policy) === null || _item$policy5 === void 0 ? void 0 : _item$policy5.deprecated;
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
        className: "eui-textBreakAll",
        "data-test-subj": "policyTablePolicyNameLink"
      }, (0, _public.reactRouterNavigate)(history, (0, _navigation.getPolicyEditPath)(value), () => (0, _ui_metric.trackUiMetric)(_analytics.METRIC_TYPE.CLICK, _constants.UIM_EDIT_CLICK))), value), isDeprecated && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: deprecatedPolicyTooltips.badgeTooltip
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "warning",
        "data-test-subj": "deprecatedPolicyBadge"
      }, deprecatedPolicyTooltips.badge))), isManaged && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: managedPolicyTooltips.badgeTooltip
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        "data-test-subj": "managedPolicyBadge"
      }, managedPolicyTooltips.badge))));
    }
  }, {
    'data-test-subj': 'policy-indexTemplates',
    field: 'indexTemplates',
    name: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.headers.indexTemplatesHeader', {
      defaultMessage: 'Linked index templates'
    }),
    sortable: ({
      indexTemplates
    }) => (indexTemplates !== null && indexTemplates !== void 0 ? indexTemplates : []).length,
    render: (value, policy) => {
      return value && value.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: actionTooltips.viewIndices,
        position: "left"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        flush: "both",
        "data-test-subj": "viewIndexTemplates",
        onClick: () => setListAction({
          selectedPolicy: policy,
          actionType: 'viewIndexTemplates'
        })
      }, value.length)) : '0';
    }
  }, {
    'data-test-subj': 'policy-indices',
    field: 'indices',
    name: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.headers.linkedIndicesHeader', {
      defaultMessage: 'Linked indices'
    }),
    sortable: ({
      indices
    }) => (indices !== null && indices !== void 0 ? indices : []).length,
    render: (value, policy) => {
      return value && value.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: actionTooltips.viewIndices,
        position: "left"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: (0, _navigation.getIndicesListPath)(policy.name, getUrlForApp)
      }, value.length)) : '0';
    }
  }, {
    'data-test-subj': 'policy-modifiedDate',
    field: 'modifiedDate',
    name: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.headers.modifiedDateHeader', {
      defaultMessage: 'Modified date'
    }),
    sortable: true,
    render: value => {
      return value ? (0, _moment.default)(value).format('MMM D, YYYY') : value;
    }
  }, {
    actions: [{
      render: policy => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: actionTooltips.addIndexTemplate
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          "data-test-subj": "addPolicyToTemplate",
          onClick: () => setListAction({
            selectedPolicy: policy,
            actionType: 'addIndexTemplate'
          }),
          iconType: "plusInCircle",
          "aria-label": actionTooltips.addIndexTemplate
        }));
      }
    }, {
      render: (policy, enabled) => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: enabled ? actionTooltips.deleteEnabled : actionTooltips.deleteDisabled
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          "data-test-subj": "deletePolicy",
          onClick: () => setListAction({
            selectedPolicy: policy,
            actionType: 'deletePolicy'
          }),
          iconType: "trash",
          "aria-label": actionTooltips.deleteEnabled,
          disabled: !enabled
        }));
      },
      enabled: policy => !(0, _policies.hasLinkedIndices)(policy)
    }],
    name: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.headers.actionsHeader', {
      defaultMessage: 'Actions'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    tableCaption: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.captionText', {
      defaultMessage: 'The table below contains {count, plural, one {# Index Lifecycle policy} other {# Index Lifecycle policies}} .',
      values: {
        count: policies.length
      }
    }),
    pagination: true,
    sorting: {
      sort: {
        field: 'name',
        direction: 'asc'
      }
    },
    search: searchOptions,
    tableLayout: "auto",
    items: filteredPolicies,
    columns: columns,
    rowProps: policy => ({
      'data-test-subj': `policyTableRow-${policy.name}`
    })
  });
};
exports.PolicyTable = PolicyTable;