"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.savePolicy = void 0;
var _i18n = require("@kbn/i18n");
var _analytics = require("@kbn/analytics");
var _constants = require("../../constants");
var _notification = require("../../services/notification");
var _api = require("../../services/api");
var _ui_metric = require("../../services/ui_metric");
var _api_errors = require("../../services/api_errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const savePolicy = async (serializedPolicy, isNew) => {
  try {
    await (0, _api.savePolicy)(serializedPolicy);
  } catch (err) {
    const title = _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.saveErrorMessage', {
      defaultMessage: 'Error saving lifecycle policy {lifecycleName}',
      values: {
        lifecycleName: serializedPolicy.name
      }
    });
    (0, _api_errors.showApiError)(err, title);
    return false;
  }
  const uiMetrics = (0, _ui_metric.getUiMetricsForPhases)(serializedPolicy.phases);
  uiMetrics.push(isNew ? _constants.UIM_POLICY_CREATE : _constants.UIM_POLICY_UPDATE);
  (0, _ui_metric.trackUiMetric)(_analytics.METRIC_TYPE.COUNT, uiMetrics);
  const message = _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.successfulSaveMessage', {
    defaultMessage: '{verb} lifecycle policy "{lifecycleName}"',
    values: {
      verb: isNew ? _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.createdMessage', {
        defaultMessage: 'Created'
      }) : _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.updatedMessage', {
        defaultMessage: 'Updated'
      }),
      lifecycleName: serializedPolicy.name
    }
  });
  _notification.toasts.addSuccess(message);
  return true;
};
exports.savePolicy = savePolicy;