"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MinAgeField = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../../shared_imports");
var _form = require("../../../../form");
var _lib = require("../../../../lib");
var _constants = require("../../../../constants");
var _util = require("./util");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  rolloverToolTipDescription: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.minimumAge.rolloverToolTipDescription', {
    defaultMessage: 'Data age is calculated from rollover. Rollover is configured in the hot phase.'
  }),
  minAgeUnitFieldSuffix: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.minimumAge.minimumAgeFieldSuffixLabel', {
    defaultMessage: 'old'
  })
};
const MinAgeField = ({
  phase
}) => {
  const minAgeValuePath = `phases.${phase}.min_age`;
  const minAgeUnitPath = `_meta.${phase}.minAgeUnit`;
  const {
    isUsingRollover
  } = (0, _form.useConfiguration)();
  const globalFields = (0, _form.useGlobalFields)();
  const {
    setValue: setMillisecondValue
  } = globalFields[`${phase}MinAgeMilliSeconds`];
  const [formData] = (0, _shared_imports.useFormData)({
    watch: [minAgeValuePath, minAgeUnitPath]
  });
  const minAgeValue = (0, _lodash.get)(formData, minAgeValuePath);
  const minAgeUnit = (0, _lodash.get)(formData, minAgeUnitPath);
  (0, _react.useEffect)(() => {
    // Whenever the min_age value of the field OR the min_age unit
    // changes, we update the corresponding millisecond global field for the phase
    if (minAgeValue === undefined) {
      return;
    }
    const milliseconds = minAgeValue.trim() === '' ? -1 : (0, _lib.getPhaseMinAgeInMilliseconds)(minAgeValue, minAgeUnit);
    setMillisecondValue(milliseconds);
  }, [minAgeValue, minAgeUnit, setMillisecondValue]);
  (0, _react.useEffect)(() => {
    return () => {
      // When unmounting (meaning we have disabled the phase), we remove
      // the millisecond value so the next time we enable the phase it will
      // be updated and trigger the validation
      setMillisecondValue(-1);
    };
  }, [setMillisecondValue]);
  return /*#__PURE__*/_react.default.createElement(_form.UseField, {
    path: minAgeValuePath
  }, field => {
    const {
      isInvalid,
      errorMessage
    } = (0, _shared_imports.getFieldValidityAndErrorMessage)(field);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      isInvalid: isInvalid,
      error: errorMessage
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: 's',
      alignItems: 'center',
      justifyContent: 'spaceBetween',
      wrap: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      className: 'eui-textNoWrap',
      size: 'xs'
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.editPolicy.minimumAge.minimumAgeFieldLabel",
      defaultMessage: "Move data into phase when:"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: 's'
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      style: {
        minWidth: 50
      },
      compressed: true,
      "aria-label": (0, _util.getTimingLabelForPhase)(phase),
      isInvalid: isInvalid,
      value: field.value,
      onChange: field.onChange,
      isLoading: field.isValidating,
      "data-test-subj": `${phase}-selectedMinimumAge`,
      min: 0
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      style: {
        minWidth: 165
      }
    }, /*#__PURE__*/_react.default.createElement(_form.UseField, {
      path: minAgeUnitPath
    }, unitField => {
      const {
        isInvalid: isUnitFieldInvalid
      } = (0, _shared_imports.getFieldValidityAndErrorMessage)(unitField);
      const icon = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": `${phase}-rolloverMinAgeInputIconTip`
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        type: "iInCircle",
        "aria-label": i18nTexts.rolloverToolTipDescription,
        content: i18nTexts.rolloverToolTipDescription
      }));
      const selectAppendValue = isUsingRollover ? [i18nTexts.minAgeUnitFieldSuffix, icon] : [i18nTexts.minAgeUnitFieldSuffix];
      const unitValue = unitField.value;
      let unitOptions = _constants.timeUnits;
      // if current unit is no longer supported as a valid time unit (e.g. nanos, micros, millis or seconds),
      // add it back to correctly display the current state
      if (unitValue && !unitOptions.some(unit => unit.value === unitValue)) {
        unitOptions = [..._constants.timeUnits, {
          value: unitValue,
          text: unitValue
        }];
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
        compressed: true,
        value: unitValue,
        onChange: e => {
          unitField.setValue(e.target.value);
        },
        isInvalid: isUnitFieldInvalid,
        append: selectAppendValue,
        "data-test-subj": `${phase}-selectedMinimumAgeUnits`,
        "aria-label": (0, _util.getUnitsAriaLabelForPhase)(phase),
        options: unitOptions
      });
    }))))));
  });
};
exports.MinAgeField = MinAgeField;