"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HotPhase = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../shared_imports");
var _i18n_texts = require("../../../i18n_texts");
var _form = require("../../../form");
var _edit_policy_context = require("../../../edit_policy_context");
var _constants = require("../../../constants");
var _ = require("../..");
var _shared_fields = require("../shared_fields");
var _phase = require("../phase");
var _use_rollover_value_required_validation = require("./use_rollover_value_required_validation");
var _components = require("./components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rolloverFieldPaths = Object.values(_constants.ROLLOVER_FORM_PATHS);
const HotPhase = () => {
  const {
    license
  } = (0, _edit_policy_context.useEditPolicyContext)();
  const [formData] = (0, _shared_imports.useFormData)({
    watch: [_constants.isUsingDefaultRolloverPath, ...rolloverFieldPaths]
  });
  const {
    isUsingRollover,
    isUsingDownsampleInHotPhase
  } = (0, _form.useConfiguration)();
  const isUsingDefaultRollover = (0, _lodash.get)(formData, _constants.isUsingDefaultRolloverPath);
  const showEmptyRolloverFieldsError = (0, _use_rollover_value_required_validation.useRolloverValueRequiredValidation)();
  const {
    docLinks
  } = (0, _shared_imports.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_phase.Phase, {
    phase: "hot"
  }, /*#__PURE__*/_react.default.createElement(_.DescribedFormRow, {
    title: /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.indexLifecycleMgmt.hotPhase.rolloverFieldTitle', {
      defaultMessage: 'Rollover'
    })),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.editPolicy.hotPhase.rolloverDescriptionMessage",
      defaultMessage: "Start writing to a new index when the current index reaches a certain size, document count, or age. Enables you to optimize performance and manage resource usage when working with time series data."
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.indexLifecycleMgmt.rollover.rolloverOffsetsPhaseTimingDescriptionNote', {
      defaultMessage: 'Note: '
    })), _i18n_texts.i18nTexts.editPolicy.rolloverOffsetsHotPhaseTiming, ' ', /*#__PURE__*/_react.default.createElement(_.LearnMoreLink, {
      text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.editPolicy.hotPhase.learnAboutRolloverLinkText",
        defaultMessage: "Learn more"
      }),
      docPath: docLinks.links.elasticsearch.ilmRollover
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_form.UseField, {
      path: _constants.isUsingDefaultRolloverPath
    }, field => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "default"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: field.label,
      checked: field.value,
      onChange: e => field.setValue(e.target.checked),
      "data-test-subj": "useDefaultRolloverSwitch"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.editPolicy.hotPhase.rolloverDefaultsTipContent",
      defaultMessage: "Roll over when an index is 30 days old or any primary shard reaches 50 gigabytes."
    })))),
    fullWidth: true
  }, isUsingDefaultRollover === false ? /*#__PURE__*/_react.default.createElement("div", {
    "aria-live": "polite",
    role: "region"
  }, /*#__PURE__*/_react.default.createElement(_form.UseField, {
    path: "_meta.hot.customRollover.enabled"
  }, field => /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: field.label,
    checked: field.value,
    onChange: e => field.setValue(e.target.checked),
    "data-test-subj": "rolloverSwitch"
  })), isUsingRollover && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), showEmptyRolloverFieldsError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: _i18n_texts.i18nTexts.editPolicy.errors.rollOverConfigurationCallout.title,
    "data-test-subj": "rolloverSettingsRequired",
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement("div", null, _i18n_texts.i18nTexts.editPolicy.errors.rollOverConfigurationCallout.body)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_components.MaxPrimaryShardSizeField, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_components.MaxPrimaryShardDocsField, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_components.MaxAgeField, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_components.MaxDocumentCountField, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_components.MaxIndexSizeField, null))) : /*#__PURE__*/_react.default.createElement("div", null)), isUsingRollover && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_fields.ForcemergeField, {
    phase: 'hot'
  }), /*#__PURE__*/_react.default.createElement(_shared_fields.ShrinkField, {
    phase: 'hot'
  }), license.canUseSearchableSnapshot() && /*#__PURE__*/_react.default.createElement(_shared_fields.SearchableSnapshotField, {
    phase: "hot"
  }), /*#__PURE__*/_react.default.createElement(_shared_fields.DownsampleField, {
    phase: "hot"
  }), !isUsingDownsampleInHotPhase && /*#__PURE__*/_react.default.createElement(_shared_fields.ReadonlyField, {
    phase: 'hot'
  })), /*#__PURE__*/_react.default.createElement(_shared_fields.IndexPriorityField, {
    phase: 'hot'
  }));
};
exports.HotPhase = HotPhase;