"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openImageEditor = void 0;
var _react = _interopRequireDefault(require("react"));
var _presentationContainers = require("@kbn/presentation-containers");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _sharedUxFileContext = require("@kbn/shared-ux-file-context");
var _imports = require("../../imports");
var _kibana_services = require("../../services/kibana_services");
var _validate_url = require("../../utils/validate_url");
var _image_viewer_context = require("../image_viewer/image_viewer_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const openImageEditor = async ({
  parentApi,
  initialImageConfig
}) => {
  const {
    ImageEditorFlyout
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('./image_editor_flyout')));
  const {
    overlays,
    theme,
    i18n,
    http,
    security
  } = _kibana_services.coreServices;
  const user = await security.authc.getCurrentUser();
  const filesClient = _kibana_services.filesService.filesClientFactory.asUnscoped();

  /**
   * If available, the parent API will keep track of which flyout is open and close it
   * if the app changes, disable certain actions when the flyout is open, etc.
   */
  const overlayTracker = (0, _presentationContainers.tracksOverlays)(parentApi) ? parentApi : undefined;
  return new Promise((resolve, reject) => {
    const onSave = imageConfig => {
      resolve(imageConfig);
      flyoutSession.close();
      overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.clearOverlays();
    };
    const onCancel = () => {
      reject();
      flyoutSession.close();
      overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.clearOverlays();
    };
    const flyoutSession = overlays.openFlyout((0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_sharedUxFileContext.FilesContext, {
      client: filesClient
    }, /*#__PURE__*/_react.default.createElement(_image_viewer_context.ImageViewerContext.Provider, {
      value: {
        getImageDownloadHref: fileId => {
          return filesClient.getDownloadHref({
            id: fileId,
            fileKind: _imports.imageEmbeddableFileKind.id
          });
        },
        validateUrl: (0, _validate_url.createValidateUrl)(http.externalUrl)
      }
    }, /*#__PURE__*/_react.default.createElement(ImageEditorFlyout, {
      user: user,
      onCancel: onCancel,
      onSave: onSave,
      initialImageConfig: initialImageConfig
    }))), {
      theme,
      i18n
    }), {
      onClose: () => {
        onCancel();
      },
      ownFocus: true,
      'data-test-subj': 'createImageEmbeddableFlyout'
    });
    overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.openOverlay(flyoutSession);
  });
};
exports.openImageEditor = openImageEditor;