"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.polyfillLocale = polyfillLocale;
var _shouldPolyfill = require("@formatjs/intl-pluralrules/should-polyfill");
var _shouldPolyfill2 = require("@formatjs/intl-relativetimeformat/should-polyfill");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// formatJS polyfills docs: https://formatjs.io/docs/polyfills/intl-pluralrules/
async function polyfillLocale(locale) {
  await Promise.all([maybePolyfillPluralRules(locale), maybePolyfillRelativetimeformatRules(locale)]);
}
async function maybePolyfillPluralRules(locale) {
  const unsupportedLocale = (0, _shouldPolyfill.shouldPolyfill)(locale);

  // This locale is supported
  if (!unsupportedLocale) {
    return;
  }

  // Load the polyfill 1st BEFORE loading data
  await Promise.resolve().then(() => _interopRequireWildcard(require('@formatjs/intl-pluralrules/polyfill-force')));
  await (specifier => new Promise(r => r(specifier)).then(s => _interopRequireWildcard(require(s))))(`@formatjs/intl-pluralrules/locale-data/${unsupportedLocale}`);
}
async function maybePolyfillRelativetimeformatRules(locale) {
  const unsupportedLocale = (0, _shouldPolyfill2.shouldPolyfill)(locale);

  // This locale is supported
  if (!unsupportedLocale) {
    return;
  }

  // Load the polyfill 1st BEFORE loading data
  await Promise.resolve().then(() => _interopRequireWildcard(require('@formatjs/intl-relativetimeformat/polyfill-force')));
  await (specifier => new Promise(r => r(specifier)).then(s => _interopRequireWildcard(require(s))))(`@formatjs/intl-relativetimeformat/locale-data/${unsupportedLocale}`);
}