"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleIntlError = void 0;
var _intl = require("@formatjs/intl");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const handleIntlError = error => {
  // Dont throw on missing translations.
  if (error.code !== _intl.IntlErrorCode.MISSING_TRANSLATION) {
    // eslint-disable-next-line no-console
    console.error('Error Parsing translation string. This will start throwing an error once the i18n package tooling is upgraded.');
    // eslint-disable-next-line no-console
    console.error(error);
  }
};
exports.handleIntlError = handleIntlError;