"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TutorialService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @public */

/** @public */

/** @public */

class TutorialService {
  constructor() {
    (0, _defineProperty2.default)(this, "tutorialVariables", {});
    (0, _defineProperty2.default)(this, "tutorialDirectoryHeaderLinks", {});
    (0, _defineProperty2.default)(this, "tutorialModuleNotices", {});
    (0, _defineProperty2.default)(this, "customStatusCheck", {});
    (0, _defineProperty2.default)(this, "customComponent", {});
  }
  setup() {
    return {
      /**
       * Set a variable usable in tutorial templates. Access with `{config.<key>}`.
       */
      setVariable: (key, value) => {
        if (this.tutorialVariables[key]) {
          throw new Error('variable already set');
        }
        this.tutorialVariables[key] = value;
      },
      /**
       * Registers a component that will be rendered next to tutorial directory title/header area.
       */
      registerDirectoryHeaderLink: (id, component) => {
        if (this.tutorialDirectoryHeaderLinks[id]) {
          throw new Error(`directory header link ${id} already set`);
        }
        this.tutorialDirectoryHeaderLinks[id] = component;
      },
      /**
       * Registers a component that will be rendered in the description of a tutorial that is associated with a module.
       */
      registerModuleNotice: (id, component) => {
        if (this.tutorialModuleNotices[id]) {
          throw new Error(`module notice ${id} already set`);
        }
        this.tutorialModuleNotices[id] = component;
      },
      registerCustomStatusCheck: (name, fnCallback) => {
        this.customStatusCheck[name] = fnCallback;
      },
      registerCustomComponent: (name, component) => {
        this.customComponent[name] = component;
      }
    };
  }
  getVariables() {
    return this.tutorialVariables;
  }
  getDirectoryHeaderLinks() {
    return Object.values(this.tutorialDirectoryHeaderLinks);
  }
  getModuleNotices() {
    return Object.values(this.tutorialModuleNotices);
  }
  getCustomStatusCheck(customStatusCheckName) {
    return this.customStatusCheck[customStatusCheckName];
  }
  getCustomComponent(customComponentName) {
    return this.customComponent[customComponentName];
  }
}
exports.TutorialService = TutorialService;