"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Welcome = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _analytics = require("@kbn/analytics");
var _i18nReact = require("@kbn/i18n-react");
var _kibana_services = require("../kibana_services");
var _sample_data = require("./sample_data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/*
 * The UI and related logic for the welcome screen that *should* show only
 * when it is enabled (the default) and there is no Kibana-consumed data
 * in Elasticsearch.
 */

/**
 * Shows a full-screen welcome page that gives helpful quick links to beginners.
 */
class Welcome extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "services", (0, _kibana_services.getServices)());
    (0, _defineProperty2.default)(this, "hideOnEsc", e => {
      if (e.key === 'Escape') {
        this.props.onSkip();
      }
    });
    (0, _defineProperty2.default)(this, "onSampleDataDecline", () => {
      this.services.trackUiMetric(_analytics.METRIC_TYPE.CLICK, 'sampleDataDecline');
      this.props.onSkip();
    });
    (0, _defineProperty2.default)(this, "onSampleDataConfirm", () => {
      this.services.trackUiMetric(_analytics.METRIC_TYPE.CLICK, 'sampleDataConfirm');
      this.redirectToAddData();
    });
  }
  redirectToAddData() {
    this.services.application.navigateToApp('integrations', {
      path: '/browse'
    });
  }
  componentDidMount() {
    const {
      welcomeService
    } = this.services;
    this.services.trackUiMetric(_analytics.METRIC_TYPE.LOADED, 'welcomeScreenMount');
    document.addEventListener('keydown', this.hideOnEsc);
    welcomeService.onRendered();
  }
  componentWillUnmount() {
    document.removeEventListener('keydown', this.hideOnEsc);
  }
  render() {
    const {
      urlBasePath
    } = this.props;
    const {
      welcomeService
    } = this.services;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement("div", {
      className: "homWelcome",
      "data-test-subj": "homeWelcomeInterstitial"
    }, /*#__PURE__*/_react.default.createElement("header", {
      className: "homWelcome__header"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "homWelcome__content eui-textCenter"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xl"
    }), /*#__PURE__*/_react.default.createElement("span", {
      className: "homWelcome__logo"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "logoElastic",
      size: "xxl"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "l",
      className: "homWelcome__title"
    }, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "home.welcomeTitle",
      defaultMessage: "Welcome to Elastic"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }))), /*#__PURE__*/_react.default.createElement("div", {
      className: "homWelcome__content homWelcome-body"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "l"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_sample_data.SampleDataCard, {
      urlBasePath: urlBasePath,
      onConfirm: this.onSampleDataConfirm,
      onDecline: this.onSampleDataDecline
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), welcomeService.renderTelemetryNotice())))));
  }
}
exports.Welcome = Welcome;