"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectsInstaller = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/* eslint-disable no-multi-str*/

class SavedObjectsInstallerUi extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "DEFAULT_BUTTON_LABEL", this.props.intl.formatMessage({
      id: 'home.tutorial.savedObject.defaultButtonLabel',
      defaultMessage: 'Load Kibana objects'
    }));
    (0, _defineProperty2.default)(this, "state", {
      isInstalling: false,
      isInstalled: false,
      overwrite: false,
      buttonLabel: this.DEFAULT_BUTTON_LABEL
    });
    (0, _defineProperty2.default)(this, "installSavedObjects", async () => {
      this.setState({
        isInstalling: true
      });
      let resp;
      try {
        // Filter out the saved object version field, if present, to avoid inadvertently triggering optimistic concurrency control.
        const objectsToCreate = this.props.savedObjects.map(
        // eslint-disable-next-line no-unused-vars
        ({
          version,
          ...savedObject
        }) => savedObject);
        resp = await this.props.bulkCreate(objectsToCreate, {
          overwrite: this.state.overwrite
        });
      } catch (error) {
        if (!this._isMounted) {
          return;
        }
        this.setState({
          isInstalling: false,
          installStatusMsg: this.props.intl.formatMessage({
            id: 'home.tutorial.savedObject.requestFailedErrorMessage',
            defaultMessage: 'Request failed, Error: {message}'
          }, {
            message: error.message
          }),
          isInstalled: false,
          overwrite: false,
          buttonLabel: this.DEFAULT_BUTTON_LABEL
        });
        return;
      }
      if (!this._isMounted) {
        return;
      }
      const errors = resp.savedObjects.filter(savedObject => {
        return Boolean(savedObject.error);
      });
      const overwriteErrors = errors.filter(savedObject => {
        return savedObject.error.statusCode === 409;
      });
      if (overwriteErrors.length > 0) {
        this.setState({
          isInstalling: false,
          installStatusMsg: this.props.intl.formatMessage({
            id: 'home.tutorial.savedObject.installStatusLabel',
            defaultMessage: "{overwriteErrorsLength} of {savedObjectsLength} objects already exist. \
Click 'Confirm overwrite' to import and overwrite existing objects. Any changes to the objects will be lost."
          }, {
            overwriteErrorsLength: overwriteErrors.length,
            savedObjectsLength: this.props.savedObjects.length
          }),
          isInstalled: false,
          overwrite: true,
          buttonLabel: this.props.intl.formatMessage({
            id: 'home.tutorial.savedObject.confirmButtonLabel',
            defaultMessage: 'Confirm overwrite'
          })
        });
        return;
      }
      const hasErrors = errors.length > 0;
      const statusMsg = hasErrors ? this.props.intl.formatMessage({
        id: 'home.tutorial.savedObject.unableToAddErrorMessage',
        defaultMessage: 'Unable to add {errorsLength} of {savedObjectsLength} kibana objects, Error: {errorMessage}'
      }, {
        errorsLength: errors.length,
        savedObjectsLength: this.props.savedObjects.length,
        errorMessage: errors[0].error.message
      }) : this.props.intl.formatMessage({
        id: 'home.tutorial.savedObject.addedLabel',
        defaultMessage: '{savedObjectsLength} saved objects successfully added'
      }, {
        savedObjectsLength: this.props.savedObjects.length
      });
      this.setState({
        isInstalling: false,
        installStatusMsg: statusMsg,
        isInstalled: !hasErrors,
        overwrite: false,
        buttonLabel: this.DEFAULT_BUTTON_LABEL
      });
    });
  }
  componentDidMount() {
    this._isMounted = true;
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  renderInstallMessage() {
    if (!this.state.installStatusMsg) {
      return;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: this.state.installStatusMsg,
      color: this.state.isInstalled ? 'success' : 'warning',
      "data-test-subj": this.state.isInstalled ? 'loadSavedObjects_success' : 'loadSavedObjects_failed'
    });
  }
  render() {
    const installMsg = this.props.installMsg ? this.props.installMsg : this.props.intl.formatMessage({
      id: 'home.tutorial.savedObject.installLabel',
      defaultMessage: 'Imports index pattern, visualizations and pre-defined dashboards.'
    });
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("h2", null, this.props.intl.formatMessage({
      id: 'home.tutorial.savedObject.loadTitle',
      defaultMessage: 'Load Kibana objects'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, installMsg))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: this.installSavedObjects,
      isLoading: this.state.isInstalling,
      "data-test-subj": "loadSavedObjects"
    }, this.state.buttonLabel))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), this.renderInstallMessage());
  }
}
const savedObjectShape = _propTypes.default.shape({
  id: _propTypes.default.string.isRequired,
  type: _propTypes.default.string.isRequired,
  attributes: _propTypes.default.object.isRequired
});
SavedObjectsInstallerUi.propTypes = {
  bulkCreate: _propTypes.default.func.isRequired,
  savedObjects: _propTypes.default.arrayOf(savedObjectShape).isRequired,
  installMsg: _propTypes.default.string
};
const SavedObjectsInstaller = exports.SavedObjectsInstaller = (0, _i18nReact.injectI18n)(SavedObjectsInstallerUi);