"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConfigService = getConfigService;
var _repoInfo = require("@kbn/repo-info");
var _repoPackages = require("@kbn/repo-packages");
var _config = require("@kbn/config");
var _read_argv = require("./read_argv");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const CONFIG_CLI_FLAGS = ['-c', '--config'];
const DEFAULT_CONFIG_PATH = (0, _repoInfo.fromRoot)('config/gateway.yml');

// These `cliArgs` are required by `Env` for use with Kibana,
// however they have no effect on the health gateway.
const KIBANA_CLI_ARGS = {
  dev: false,
  silent: false,
  watch: false,
  basePath: false,
  disableOptimizer: true,
  cache: false,
  dist: false,
  oss: false,
  runExamples: false
};
function getConfigService({
  logger
}) {
  const configPathOverride = (0, _read_argv.getArgValues)(process.argv, CONFIG_CLI_FLAGS);
  const configPath = configPathOverride.length ? configPathOverride : [DEFAULT_CONFIG_PATH];
  const rawConfigService = new _config.RawConfigService(configPath);
  rawConfigService.loadConfig();
  const env = _config.Env.createDefault(_repoInfo.REPO_ROOT, {
    configs: configPath,
    cliArgs: KIBANA_CLI_ARGS,
    repoPackages: (0, _repoPackages.getPackages)(_repoInfo.REPO_ROOT)
  });
  return new _config.ConfigService(rawConfigService, env, logger);
}