"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GuidePanelFlyoutHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const GuidePanelFlyoutHeader = ({
  styles,
  titleId,
  toggleGuide,
  hasError,
  isGuideReadyToComplete,
  guideConfig,
  backButton
}) => {
  /**
   * ESC key closes CustomFlyout
   */
  const onKeyDown = event => {
    if (event.key === _eui.keys.ESCAPE) {
      event.preventDefault();
      event.stopPropagation();
      toggleGuide();
    }
  };
  const getTitle = () => {
    if (isGuideReadyToComplete) {
      return _i18n.i18n.translate('guidedOnboarding.dropdownPanel.completeGuideFlyoutTitle', {
        defaultMessage: 'Well done!'
      });
    }
    return guideConfig ? guideConfig.title : '';
  };
  const closeIcon = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "cross",
    "aria-label": _i18n.i18n.translate('guidedOnboarding.dropdownPanel.closeButton.ariaLabel', {
      defaultMessage: 'Close modal'
    }),
    onClick: toggleGuide,
    onKeyDown: onKeyDown,
    color: "text",
    css: styles.flyoutOverrides.flyoutCloseButtonIcon
  });
  if (hasError) {
    return /*#__PURE__*/_react.default.createElement("div", {
      css: styles.flyoutOverrides.flyoutHeaderError
    }, backButton, closeIcon);
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.flyoutOverrides.flyoutHeader
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), backButton, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: titleId,
    "data-test-subj": "guideTitle"
  }, getTitle())), closeIcon, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null));
};
exports.GuidePanelFlyoutHeader = GuidePanelFlyoutHeader;