"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GraphStorage = void 0;
var _contentManagementUtils = require("@kbn/content-management-utils");
var _cm_services = require("../../common/content_management/cm_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SO_TYPE = 'graph-workspace';
class GraphStorage extends _contentManagementUtils.SOContentStorage {
  constructor({
    logger,
    throwOnResultValidationError
  }) {
    super({
      savedObjectType: SO_TYPE,
      cmServicesDefinition: _cm_services.cmServicesDefinition,
      allowedSavedObjectAttributes: ['title', 'description', 'kibanaSavedObjectMeta', 'wsState', 'version', 'numLinks', 'numVertices', 'legacyIndexPatternRef'],
      logger,
      throwOnResultValidationError
    });
  }
}
exports.GraphStorage = GraphStorage;