"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectStyle = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SelectStyle = ({
  colors,
  workspace
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "gphSidebar__panel"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "gphSidebar__header"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "brush",
    size: "s"
  }), ' ', _i18n.i18n.translate('xpack.graph.sidebar.styleVerticesTitle', {
    defaultMessage: 'Style selected vertices'
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "form-group form-group-sm gphFormGroup--small"
  }, colors.map(c => {
    const onSelectColor = () => {
      workspace.colorSelected(c);
      workspace.changeHandler();
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "stopFilled",
      color: c,
      className: "gphColorPicker__color",
      "aria-hidden": "true",
      onClick: onSelectColor
    });
  })));
};
exports.SelectStyle = SelectStyle;