"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerIntegrationFieldsExtractor = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerIntegrationFieldsExtractor = ({
  core,
  fieldsMetadata
}) => {
  fieldsMetadata.registerIntegrationFieldsExtractor(async ({
    integration,
    dataset
  }) => {
    const [_core, _startDeps, {
      packageService
    }] = await core.getStartServices();
    return packageService.asInternalUser.getPackageFieldsMetadata({
      packageName: integration,
      datasetName: dataset
    });
  });
};
exports.registerIntegrationFieldsExtractor = registerIntegrationFieldsExtractor;