"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stepSaveArchiveEntries = stepSaveArchiveEntries;
var _constants = require("../../../../../constants");
var _storage = require("../../../archive/storage");
var _utils = require("../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function stepSaveArchiveEntries(context) {
  const {
    packageInstallContext,
    savedObjectsClient,
    installSource
  } = context;
  const {
    packageInfo
  } = packageInstallContext;
  const packageAssetResults = await (0, _utils.withPackageSpan)('Update archive entries', () => (0, _storage.saveArchiveEntriesFromAssetsMap)({
    savedObjectsClient,
    assetsMap: packageInstallContext === null || packageInstallContext === void 0 ? void 0 : packageInstallContext.assetsMap,
    paths: packageInstallContext === null || packageInstallContext === void 0 ? void 0 : packageInstallContext.paths,
    packageInfo,
    installSource
  }));
  const packageAssetRefs = packageAssetResults.saved_objects.map(result => ({
    id: result.id,
    type: _constants.ASSETS_SAVED_OBJECT_TYPE
  }));
  return {
    packageAssetRefs
  };
}