"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stepInstallIndexTemplatePipelines = stepInstallIndexTemplatePipelines;
var _services = require("../../../../../../common/services");
var _install_index_template_pipeline = require("../../install_index_template_pipeline");
var _utils = require("../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function stepInstallIndexTemplatePipelines(context) {
  var _context$esReferences;
  const {
    esClient,
    savedObjectsClient,
    packageInstallContext,
    logger,
    installedPkg
  } = context;
  const {
    packageInfo
  } = packageInstallContext;
  const esReferences = (_context$esReferences = context.esReferences) !== null && _context$esReferences !== void 0 ? _context$esReferences : [];
  if (packageInfo.type === 'integration') {
    logger.debug(`Package install - Installing index templates and pipelines, packageInfo.type: ${packageInfo.type}`);
    const {
      installedTemplates,
      esReferences: templateEsReferences
    } = await (0, _utils.withPackageSpan)('Install index templates and pipelines with packageInfo integration', () => (0, _install_index_template_pipeline.installIndexTemplatesAndPipelines)({
      installedPkg: installedPkg ? installedPkg.attributes : undefined,
      packageInstallContext,
      esClient,
      savedObjectsClient,
      logger,
      esReferences
    }));
    return {
      esReferences: templateEsReferences,
      indexTemplates: installedTemplates
    };
  }
  if (packageInfo.type === 'input' && installedPkg) {
    // input packages create their data streams during package policy creation
    // we must use installed_es to infer which streams exist first then
    // we can install the new index templates
    logger.debug(`Package install - packageInfo.type: ${packageInfo.type}`);
    const dataStreamNames = installedPkg.attributes.installed_es.filter(ref => ref.type === 'index_template')
    // index templates are named {type}-{dataset}, remove everything before first hyphen
    .map(ref => ref.id.replace(/^[^-]+-/, ''));
    const dataStreams = dataStreamNames.flatMap(dataStreamName => (0, _services.getNormalizedDataStreams)(packageInfo, dataStreamName));
    if (dataStreams.length) {
      const {
        installedTemplates,
        esReferences: templateEsReferences
      } = await (0, _utils.withPackageSpan)('Install index templates and pipelines with packageInfo input', () => (0, _install_index_template_pipeline.installIndexTemplatesAndPipelines)({
        installedPkg: installedPkg ? installedPkg.attributes : undefined,
        packageInstallContext,
        esClient,
        savedObjectsClient,
        logger,
        esReferences,
        onlyForDataStreams: dataStreams
      }));
      return {
        esReferences: templateEsReferences,
        indexTemplates: installedTemplates
      };
    }
  }
}