"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stepInstallILMPolicies = stepInstallILMPolicies;
var _ = require("../../../..");
var _install = require("../../../elasticsearch/datastream_ilm/install");
var _install2 = require("../../../elasticsearch/ilm/install");
var _utils = require("../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function stepInstallILMPolicies(context) {
  var _installedPkg$attribu, _appContextService$ge, _appContextService$ge2, _appContextService$ge3;
  const {
    logger,
    packageInstallContext,
    esClient,
    savedObjectsClient,
    installedPkg
  } = context;

  // Array that gets updated by each operation. This allows each operation to accurately update the
  // installation object with its references without requiring a refresh of the SO index on each update (faster).
  let esReferences = (_installedPkg$attribu = installedPkg === null || installedPkg === void 0 ? void 0 : installedPkg.attributes.installed_es) !== null && _installedPkg$attribu !== void 0 ? _installedPkg$attribu : [];

  // currently only the base package has an ILM policy
  // at some point ILM policies can be installed/modified
  // per data stream and we should then save them
  const isILMPoliciesDisabled = (_appContextService$ge = (_appContextService$ge2 = _.appContextService.getConfig()) === null || _appContextService$ge2 === void 0 ? void 0 : (_appContextService$ge3 = _appContextService$ge2.internal) === null || _appContextService$ge3 === void 0 ? void 0 : _appContextService$ge3.disableILMPolicies) !== null && _appContextService$ge !== void 0 ? _appContextService$ge : false;
  if (!isILMPoliciesDisabled) {
    esReferences = await (0, _utils.withPackageSpan)('Install ILM policies', () => (0, _install2.installILMPolicy)(packageInstallContext, esClient, savedObjectsClient, logger, esReferences));
    ({
      esReferences
    } = await (0, _utils.withPackageSpan)('Install Data Stream ILM policies', () => (0, _install.installIlmForDataStream)(packageInstallContext, esClient, savedObjectsClient, logger, esReferences)));
  }
  // always return esReferences even when isILMPoliciesDisabled is false as it's the first time we are writing to it
  return {
    esReferences
  };
}