"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDefaultPipeline = void 0;
var yaml = _interopRequireWildcard(require("js-yaml"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// NOTE: The install methods will take care of adding a reference to a @custom pipeline. We don't need to add one here.
const createDefaultPipeline = (dataset, type) => {
  const pipeline = {
    processors: [{
      set: {
        description: "If '@timestamp' is missing, set it with the ingest timestamp",
        field: '@timestamp',
        override: false,
        copy_from: '_ingest.timestamp'
      }
    }],
    _meta: {
      description: `default pipeline for the ${dataset} dataset`,
      managed: true
    }
  };
  return yaml.dump(pipeline);
};
exports.createDefaultPipeline = createDefaultPipeline;