"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentServiceImpl = void 0;
var _coreSavedObjectsUtilsServer = require("@kbn/core-saved-objects-utils-server");
var _security = require("../security");
var _app_context = require("../app_context");
var _errors = require("../../errors");
var _crud = require("./crud");
var _status = require("./status");
var _versions = require("./versions");
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */ /* eslint-disable max-classes-per-file */
/**
 * A service for interacting with Agent data. See {@link AgentClient} for more information.
 *
 * @public
 */
/**
 * A client for interacting with data about an Agent
 *
 * @public
 */
var _runPreflight = /*#__PURE__*/new WeakMap();
/**
 * @internal
 */
class AgentClientImpl {
  constructor(internalEsClient, soClient, preflightCheck, spaceId) {
    _classPrivateFieldInitSpec(this, _runPreflight, async () => {
      if (this.preflightCheck) {
        return this.preflightCheck();
      }
    });
    this.internalEsClient = internalEsClient;
    this.soClient = soClient;
    this.preflightCheck = preflightCheck;
    this.spaceId = spaceId;
  }
  async listAgents(options) {
    await _classPrivateFieldGet(_runPreflight, this).call(this);
    return (0, _crud.getAgentsByKuery)(this.internalEsClient, this.soClient, {
      ...options,
      spaceId: this.spaceId
    });
  }
  async getAgent(agentId) {
    await _classPrivateFieldGet(_runPreflight, this).call(this);
    return (0, _crud.getAgentById)(this.internalEsClient, this.soClient, agentId);
  }
  async getAgentStatusById(agentId) {
    await _classPrivateFieldGet(_runPreflight, this).call(this);
    return (0, _status.getAgentStatusById)(this.internalEsClient, this.soClient, agentId);
  }
  async getAgentStatusForAgentPolicy(agentPolicyId, filterKuery) {
    await _classPrivateFieldGet(_runPreflight, this).call(this);
    return (0, _status.getAgentStatusForAgentPolicy)(this.internalEsClient, this.soClient, agentPolicyId, filterKuery, this.spaceId);
  }
  async getLatestAgentAvailableVersion(includeCurrentVersion) {
    await _classPrivateFieldGet(_runPreflight, this).call(this);
    return (0, _versions.getLatestAvailableAgentVersion)({
      includeCurrentVersion
    });
  }
}

/**
 * @internal
 */
class AgentServiceImpl {
  constructor(internalEsClient, soClient) {
    this.internalEsClient = internalEsClient;
    this.soClient = soClient;
  }
  asScoped(req) {
    var _soClient$getCurrentN;
    const preflightCheck = async () => {
      const authz = await (0, _security.getAuthzFromRequest)(req);
      if (!authz.fleet.all && !authz.fleet.readAgents) {
        throw new _errors.FleetUnauthorizedError(`User does not have adequate permissions to access Fleet agents.`);
      }
    };
    const soClient = _app_context.appContextService.getInternalUserSOClientForSpaceId(_app_context.appContextService.getSavedObjects().getScopedClient(req).getCurrentNamespace());
    return new AgentClientImpl(this.internalEsClient, soClient, preflightCheck, (_soClient$getCurrentN = soClient.getCurrentNamespace()) !== null && _soClient$getCurrentN !== void 0 ? _soClient$getCurrentN : _coreSavedObjectsUtilsServer.DEFAULT_NAMESPACE_STRING);
  }
  get asInternalUser() {
    return new AgentClientImpl(this.internalEsClient, this.soClient);
  }
}
exports.AgentServiceImpl = AgentServiceImpl;