"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = void 0;
var _constants = require("../../../common/constants");
var _uninstall_token = require("../../types/rest_spec/uninstall_token");
var _experimental_features = require("../../../common/experimental_features");
var _handlers = require("./handlers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRoutes = (router, config) => {
  const experimentalFeatures = (0, _experimental_features.parseExperimentalConfigValue)(config.enableExperimental);
  if (experimentalFeatures.agentTamperProtectionEnabled) {
    router.versioned.get({
      path: _constants.UNINSTALL_TOKEN_ROUTES.LIST_PATTERN,
      fleetAuthz: {
        fleet: {
          allAgents: true
        }
      }
    }).addVersion({
      version: _constants.API_VERSIONS.public.v1,
      validate: {
        request: _uninstall_token.GetUninstallTokensMetadataRequestSchema
      }
    }, _handlers.getUninstallTokensMetadataHandler);
    router.versioned.get({
      path: _constants.UNINSTALL_TOKEN_ROUTES.INFO_PATTERN,
      fleetAuthz: {
        fleet: {
          allAgents: true
        }
      }
    }).addVersion({
      version: _constants.API_VERSIONS.public.v1,
      validate: {
        request: _uninstall_token.GetUninstallTokenRequestSchema
      }
    }, _handlers.getUninstallTokenHandler);
  }
};
exports.registerRoutes = registerRoutes;