"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createStandaloneAgentApiKeyHandler = void 0;
var _api_keys = require("../../services/api_keys");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createStandaloneAgentApiKeyHandler = async (context, request, response) => {
  const coreContext = await context.core;
  const esClient = coreContext.elasticsearch.client.asCurrentUser;
  const key = await (0, _api_keys.createStandaloneAgentApiKey)(esClient, request.body.name);
  return response.ok({
    body: {
      item: key
    }
  });
};
exports.createStandaloneAgentApiKeyHandler = createStandaloneAgentApiKeyHandler;