"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = void 0;
var _constants = require("../../../common/constants");
var _types = require("../../types");
var _handler = require("./handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRoutes = router => {
  router.versioned.get({
    path: _constants.FLEET_PROXY_API_ROUTES.LIST_PATTERN,
    fleetAuthz: {
      fleet: {
        readSettings: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: false
  }, _handler.getAllFleetProxyHandler);
  router.versioned.post({
    path: _constants.FLEET_PROXY_API_ROUTES.CREATE_PATTERN,
    fleetAuthz: {
      fleet: {
        allSettings: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.PostFleetProxyRequestSchema
    }
  }, _handler.postFleetProxyHandler);
  router.versioned.put({
    path: _constants.FLEET_PROXY_API_ROUTES.UPDATE_PATTERN,
    fleetAuthz: {
      fleet: {
        allSettings: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.PutFleetProxyRequestSchema
    }
  }, _handler.putFleetProxyHandler);
  router.versioned.get({
    path: _constants.FLEET_PROXY_API_ROUTES.INFO_PATTERN,
    fleetAuthz: {
      fleet: {
        readSettings: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetOneFleetProxyRequestSchema
    }
  }, _handler.getFleetProxyHandler);
  router.versioned.delete({
    path: _constants.FLEET_PROXY_API_ROUTES.DELETE_PATTERN,
    fleetAuthz: {
      fleet: {
        allSettings: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetOneFleetProxyRequestSchema
    }
  }, _handler.deleteFleetProxyHandler);
};
exports.registerRoutes = registerRoutes;