"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.postBulkAgentsUnenrollHandler = exports.postAgentUnenrollHandler = void 0;
var AgentService = _interopRequireWildcard(require("../../services/agents"));
var _errors = require("../../errors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const postAgentUnenrollHandler = async (context, request, response) => {
  const coreContext = await context.core;
  const soClient = coreContext.savedObjects.client;
  const esClient = coreContext.elasticsearch.client.asInternalUser;
  try {
    var _request$body, _request$body2;
    await AgentService.unenrollAgent(soClient, esClient, request.params.agentId, {
      force: (_request$body = request.body) === null || _request$body === void 0 ? void 0 : _request$body.force,
      revoke: (_request$body2 = request.body) === null || _request$body2 === void 0 ? void 0 : _request$body2.revoke
    });
    const body = {};
    return response.ok({
      body
    });
  } catch (error) {
    return (0, _errors.defaultFleetErrorHandler)({
      error,
      response
    });
  }
};
exports.postAgentUnenrollHandler = postAgentUnenrollHandler;
const postBulkAgentsUnenrollHandler = async (context, request, response) => {
  const coreContext = await context.core;
  const soClient = coreContext.savedObjects.client;
  const esClient = coreContext.elasticsearch.client.asInternalUser;
  const agentOptions = Array.isArray(request.body.agents) ? {
    agentIds: request.body.agents
  } : {
    kuery: request.body.agents
  };
  try {
    var _request$body3, _request$body4, _request$body5, _request$body6;
    const results = await AgentService.unenrollAgents(soClient, esClient, {
      ...agentOptions,
      revoke: (_request$body3 = request.body) === null || _request$body3 === void 0 ? void 0 : _request$body3.revoke,
      force: (_request$body4 = request.body) === null || _request$body4 === void 0 ? void 0 : _request$body4.force,
      batchSize: (_request$body5 = request.body) === null || _request$body5 === void 0 ? void 0 : _request$body5.batchSize,
      showInactive: (_request$body6 = request.body) === null || _request$body6 === void 0 ? void 0 : _request$body6.includeInactive
    });
    return response.ok({
      body: {
        actionId: results.actionId
      }
    });
  } catch (error) {
    return (0, _errors.defaultFleetErrorHandler)({
      error,
      response
    });
  }
};
exports.postBulkAgentsUnenrollHandler = postBulkAgentsUnenrollHandler;