"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.requestDiagnosticsHandler = exports.bulkRequestDiagnosticsHandler = void 0;
var _services = require("../../../common/services");
var _agents = _interopRequireWildcard(require("../../services/agents"));
var AgentService = _agents;
var _errors = require("../../errors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const requestDiagnosticsHandler = async (context, request, response) => {
  const coreContext = await context.core;
  const esClient = coreContext.elasticsearch.client.asInternalUser;
  const soClient = coreContext.savedObjects.client;
  try {
    var _request$body;
    const agent = await (0, _agents.getAgentById)(esClient, soClient, request.params.agentId);
    if (!(0, _services.isAgentRequestDiagnosticsSupported)(agent)) {
      return response.customError({
        statusCode: 400,
        body: {
          message: `Agent ${request.params.agentId} does not support request diagnostics action.`
        }
      });
    }
    const result = await AgentService.requestDiagnostics(esClient, request.params.agentId, (_request$body = request.body) === null || _request$body === void 0 ? void 0 : _request$body.additional_metrics);
    return response.ok({
      body: {
        actionId: result.actionId
      }
    });
  } catch (error) {
    return (0, _errors.defaultFleetErrorHandler)({
      error,
      response
    });
  }
};
exports.requestDiagnosticsHandler = requestDiagnosticsHandler;
const bulkRequestDiagnosticsHandler = async (context, request, response) => {
  const coreContext = await context.core;
  const esClient = coreContext.elasticsearch.client.asInternalUser;
  const soClient = coreContext.savedObjects.client;
  const agentOptions = Array.isArray(request.body.agents) ? {
    agentIds: request.body.agents
  } : {
    kuery: request.body.agents
  };
  try {
    const result = await AgentService.bulkRequestDiagnostics(esClient, soClient, {
      ...agentOptions,
      batchSize: request.body.batchSize,
      additionalMetrics: request.body.additional_metrics
    });
    return response.ok({
      body: {
        actionId: result.actionId
      }
    });
  } catch (error) {
    return (0, _errors.defaultFleetErrorHandler)({
      error,
      response
    });
  }
};
exports.bulkRequestDiagnosticsHandler = bulkRequestDiagnosticsHandler;