"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LICENCE_FOR_MULTIPLE_AGENT_POLICIES = void 0;
exports.useMultipleAgentPolicies = useMultipleAgentPolicies;
var _services = require("../services");
var _use_license = require("./use_license");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LICENCE_FOR_MULTIPLE_AGENT_POLICIES = exports.LICENCE_FOR_MULTIPLE_AGENT_POLICIES = 'enterprise';
function useMultipleAgentPolicies() {
  const licenseService = (0, _use_license.useLicense)();
  const {
    enableReusableIntegrationPolicies
  } = _services.ExperimentalFeaturesService.get();
  const hasEnterpriseLicence = licenseService.hasAtLeast(LICENCE_FOR_MULTIPLE_AGENT_POLICIES);
  const canUseMultipleAgentPolicies = enableReusableIntegrationPolicies && hasEnterpriseLicence;
  return {
    canUseMultipleAgentPolicies
  };
}