"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigureStandaloneAgentStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfigureStandaloneAgentStep = ({
  isK8s,
  yaml,
  downloadYaml,
  apiKey,
  onCreateApiKey,
  isComplete,
  onCopy
}) => {
  const core = (0, _hooks.useStartServices)();
  const {
    docLinks
  } = core;
  const policyMsg = isK8s === 'IS_KUBERNETES' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.stepConfigureAgentDescriptionk8s",
    defaultMessage: "Copy or download the Kubernetes manifest inside the Kubernetes cluster. Update {ESUsernameVariable} and {ESPasswordVariable} environment variables in the Daemonset to match your Elasticsearch credentials. Note that the following manifest contains resource limits that may not be appropriate for a production environment, review our guide on {scalingGuideLink} before deploying this manifest.",
    values: {
      ESUsernameVariable: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "ES_USERNAME"),
      ESPasswordVariable: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "ES_PASSWORD"),
      scalingGuideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        href: docLinks.links.fleet.scalingKubernetesResourcesAndLimits,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.fleet.agentEnrollment.k8ScalingGuideLinkText",
        defaultMessage: "Scaling Elastic Agent on Kubernetes"
      }))
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.stepConfigureAgentDescription",
    defaultMessage: "Copy this policy to the {fileName} on the host where the Elastic Agent is installed. Either use an existing API key and modify {apiKeyVariable} in the {outputSection} section of {fileName} or click the button below to generate a new one. Refer to {guideLink} for details.",
    values: {
      fileName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "elastic-agent.yml"),
      apiKeyVariable: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "API_KEY"),
      outputSection: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "outputs"),
      guideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        href: docLinks.links.fleet.grantESAccessToStandaloneAgents,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.fleet.agentEnrollment.standaloneAgentAccessLinkText",
        defaultMessage: "Grant standalone Elastic Agents access to Elasticsearch"
      }))
    }
  });
  const downloadMsg = isK8s === 'IS_KUBERNETES' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.downloadPolicyButtonk8s",
    defaultMessage: "Download manifest"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentEnrollment.downloadPolicyButton",
    defaultMessage: "Download policy"
  });
  return {
    title: _i18n.i18n.translate('xpack.fleet.agentEnrollment.stepConfigureAgentTitle', {
      defaultMessage: 'Configure the agent'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !yaml ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, policyMsg), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), apiKey && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.fleet.agentEnrollment.apiKeyBanner.created', {
        defaultMessage: 'API key created.'
      }),
      color: "success",
      iconType: "check",
      "data-test-subj": "obltOnboardingLogsApiKeyCreated"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.fleet.agentEnrollment.apiKeyBanner.created.description', {
      defaultMessage: `Remember to store this information in a safe place. It won't be displayed anymore after you continue.`
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      "data-test-subj": "apmAgentKeyCallOutFieldText",
      readOnly: true,
      value: apiKey,
      "aria-label": _i18n.i18n.translate('xpack.fleet.agentEnrollment.apiKeyBanner.field.label', {
        defaultMessage: 'API key'
      }),
      append: /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
        textToCopy: apiKey
      }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconType: "copyClipboard",
        onClick: copy,
        color: "success",
        css: {
          '> svg.euiIcon': {
            borderRadius: '0 !important'
          }
        },
        "aria-label": _i18n.i18n.translate('xpack.fleet.apiKeyBanner.field.copyButton', {
          defaultMessage: 'Copy to clipboard'
        })
      }))
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: onCreateApiKey
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentEnrollment.createApiKeyButton",
      defaultMessage: "Create API key"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      textToCopy: yaml
    }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: () => {
        copy();
        if (onCopy) onCopy();
      },
      iconType: "copyClipboard"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentEnrollment.copyPolicyButton",
      defaultMessage: "Copy to clipboard"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "download",
      onClick: () => {
        if (onCopy) onCopy();
        downloadYaml();
      },
      isDisabled: !downloadYaml
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, downloadMsg)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "yaml",
      style: {
        maxHeight: 300
      },
      fontSize: "m",
      "data-test-subj": "agentPolicyCodeBlock"
    }, yaml))),
    status: !yaml ? 'loading' : isComplete ? 'complete' : undefined
  };
};
exports.ConfigureStandaloneAgentStep = ConfigureStandaloneAgentStep;