"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Detail = Detail;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lt = _interopRequireDefault(require("semver/functions/lt"));
var _has_deferred_installations = require("../../../../../../services/has_deferred_installations");
var _services = require("../../../../../../../common/services");
var _constants = require("../../../../../../../common/constants");
var _hooks = require("../../../../hooks");
var _constants2 = require("../../../../constants");
var _services2 = require("../../../../services");
var _types = require("../../../../types");
var _components = require("../../../../components");
var _layouts = require("../../../../layouts");
var _deferred_assets_warning = require("./assets/deferred_assets_warning");
var _hooks2 = require("./hooks");
var _utils = require("./utils");
var _components2 = require("./components");
var _assets = require("./assets");
var _overview = require("./overview");
var _policies = require("./policies");
var _settings = require("./settings");
var _custom = require("./custom");
var _documentation = require("./documentation");
var _configs = require("./configs");
require("./index.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Divider = _styledComponents.default.div`
  width: 0;
  height: 100%;
  border-left: ${props => props.theme.eui.euiBorderThin};
`;

// Allows child text to be truncated
const FlexItemWithMinWidth = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  min-width: 0px;
`;

// to limit size of iconpanel, making the header too big
const FlexItemWithMaxHeight = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  @media (min-width: 768px) {
    max-height: 60px;
  }
`;
function Breadcrumbs({
  packageTitle
}) {
  (0, _hooks.useBreadcrumbs)('integration_details_overview', {
    pkgTitle: packageTitle
  });
  return null;
}
function Detail() {
  var _services$cloud, _packageInfo$name, _packageInfo$installa, _packageInfoData$item, _packageInfoData$item2;
  const {
    getId: getAgentPolicyId
  } = (0, _hooks.useAgentPolicyContext)();
  const {
    getFromIntegrations
  } = (0, _hooks.useIntegrationsStateContext)();
  const {
    pkgkey,
    panel
  } = (0, _reactRouterDom.useParams)();
  const {
    getHref,
    getPath
  } = (0, _hooks.useLink)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    pathname,
    search,
    hash
  } = (0, _reactRouterDom.useLocation)();
  const queryParams = (0, _react.useMemo)(() => new URLSearchParams(search), [search]);
  const integration = (0, _react.useMemo)(() => queryParams.get('integration'), [queryParams]);
  const prerelease = (0, _react.useMemo)(() => Boolean(queryParams.get('prerelease')), [queryParams]);
  const authz = (0, _hooks.useAuthz)();
  const canAddAgent = authz.fleet.addAgents;
  const canInstallPackages = authz.integrations.installPackages;
  const canReadPackageSettings = authz.integrations.readPackageSettings;
  const canReadIntegrationPolicies = authz.integrations.readIntegrationPolicies;
  const {
    data: permissionCheck,
    error: permissionCheckError,
    isLoading: isPermissionCheckLoading
  } = (0, _hooks.usePermissionCheckQuery)();
  const missingSecurityConfiguration = !(permissionCheck !== null && permissionCheck !== void 0 && permissionCheck.success) && permissionCheckError === 'MISSING_SECURITY';
  const userCanInstallPackages = canInstallPackages && (permissionCheck === null || permissionCheck === void 0 ? void 0 : permissionCheck.success);
  const services = (0, _hooks.useStartServices)();
  const isCloud = !!(services !== null && services !== void 0 && (_services$cloud = services.cloud) !== null && _services$cloud !== void 0 && _services$cloud.cloudId);
  const {
    createPackagePolicyMultiPageLayout: isExperimentalAddIntegrationPageEnabled
  } = _services2.ExperimentalFeaturesService.get();
  const agentPolicyIdFromContext = getAgentPolicyId();
  const isOverviewPage = panel === 'overview';

  // Package info state
  const [packageInfo, setPackageInfo] = (0, _react.useState)(null);
  const setPackageInstallStatus = (0, _hooks.useSetPackageInstallStatus)();
  const getPackageInstallStatus = (0, _hooks.useGetPackageInstallStatus)();
  const CustomAssets = (0, _hooks.useUIExtension)((_packageInfo$name = packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.name) !== null && _packageInfo$name !== void 0 ? _packageInfo$name : '', 'package-detail-assets');
  const packageInstallStatus = (0, _react.useMemo)(() => {
    var _getPackageInstallSta;
    if (packageInfo === null || !packageInfo.name) {
      return undefined;
    }
    return (_getPackageInstallSta = getPackageInstallStatus(packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.name)) === null || _getPackageInstallSta === void 0 ? void 0 : _getPackageInstallSta.status;
  }, [packageInfo, getPackageInstallStatus]);
  const isInstalled = (0, _react.useMemo)(() => packageInstallStatus === _types.InstallStatus.installed || packageInstallStatus === _types.InstallStatus.reinstalling, [packageInstallStatus]);
  const updateAvailable = packageInfo && 'installationInfo' in packageInfo && ((_packageInfo$installa = packageInfo.installationInfo) === null || _packageInfo$installa === void 0 ? void 0 : _packageInfo$installa.version) && (0, _lt.default)(packageInfo.installationInfo.version, packageInfo.latestVersion);
  const [prereleaseIntegrationsEnabled, setPrereleaseIntegrationsEnabled] = _react.default.useState();
  const {
    data: settings,
    isInitialLoading: isSettingsInitialLoading
  } = (0, _hooks.useGetSettingsQuery)({
    enabled: authz.fleet.readSettings
  });
  (0, _react.useEffect)(() => {
    const isEnabled = Boolean(settings === null || settings === void 0 ? void 0 : settings.item.prerelease_integrations_enabled) || prerelease;
    setPrereleaseIntegrationsEnabled(isEnabled);
  }, [settings === null || settings === void 0 ? void 0 : settings.item.prerelease_integrations_enabled, prerelease]);
  const {
    pkgName,
    pkgVersion
  } = (0, _services.splitPkgKey)(pkgkey);
  // Fetch package info
  const {
    data: packageInfoData,
    error: packageInfoError,
    isLoading: packageInfoLoading,
    isFetchedAfterMount: packageInfoIsFetchedAfterMount,
    refetch: refetchPackageInfo
  } = (0, _hooks.useGetPackageInfoByKeyQuery)(pkgName, pkgVersion, {
    prerelease: prereleaseIntegrationsEnabled
  }, {
    enabled: !authz.fleet.readSettings || !isSettingsInitialLoading,
    // Load only after settings are loaded
    refetchOnMount: 'always'
  });
  const [latestGAVersion, setLatestGAVersion] = (0, _react.useState)();
  const [latestPrereleaseVersion, setLatestPrereleaseVersion] = (0, _react.useState)();

  // fetch latest GA version (prerelease=false)
  const {
    data: packageInfoLatestGAData
  } = (0, _hooks.useGetPackageInfoByKeyQuery)(pkgName, '', {
    prerelease: false
  });
  (0, _react.useEffect)(() => {
    const pkg = packageInfoLatestGAData === null || packageInfoLatestGAData === void 0 ? void 0 : packageInfoLatestGAData.item;
    const isGAVersion = pkg && !(0, _services.isPackagePrerelease)(pkg.version);
    if (isGAVersion) {
      setLatestGAVersion(pkg.version);
    }
  }, [packageInfoLatestGAData === null || packageInfoLatestGAData === void 0 ? void 0 : packageInfoLatestGAData.item]);

  // fetch latest Prerelease version (prerelease=true)
  const {
    data: packageInfoLatestPrereleaseData
  } = (0, _hooks.useGetPackageInfoByKeyQuery)(pkgName, '', {
    prerelease: true
  });
  (0, _react.useEffect)(() => {
    setLatestPrereleaseVersion(packageInfoLatestPrereleaseData === null || packageInfoLatestPrereleaseData === void 0 ? void 0 : packageInfoLatestPrereleaseData.item.version);
  }, [packageInfoLatestPrereleaseData === null || packageInfoLatestPrereleaseData === void 0 ? void 0 : packageInfoLatestPrereleaseData.item.version]);
  const {
    isFirstTimeAgentUser = false,
    isLoading: firstTimeUserLoading
  } = (0, _hooks2.useIsFirstTimeAgentUserQuery)();
  const isGuidedOnboardingActive = (0, _hooks.useIsGuidedOnboardingActive)(pkgName);

  // Refresh package info when status change
  const [oldPackageInstallStatus, setOldPackageStatus] = (0, _react.useState)(packageInstallStatus);
  (0, _react.useEffect)(() => {
    if (packageInstallStatus === 'not_installed') {
      setOldPackageStatus(packageInstallStatus);
    }
    if (oldPackageInstallStatus === 'not_installed' && packageInstallStatus === 'installed') {
      setOldPackageStatus(packageInstallStatus);
      refetchPackageInfo();
    }
  }, [packageInstallStatus, oldPackageInstallStatus, refetchPackageInfo]);
  const isLoading = packageInfoLoading || isPermissionCheckLoading || firstTimeUserLoading || !packageInfoIsFetchedAfterMount;
  const showCustomTab = (0, _hooks.useUIExtension)((_packageInfoData$item = packageInfoData === null || packageInfoData === void 0 ? void 0 : (_packageInfoData$item2 = packageInfoData.item) === null || _packageInfoData$item2 === void 0 ? void 0 : _packageInfoData$item2.name) !== null && _packageInfoData$item !== void 0 ? _packageInfoData$item : '', 'package-detail-custom') !== undefined;

  // Only show config tab if package has `inputs`
  const showConfigTab = canAddAgent && (packageInfo ? (0, _services.packageToPackagePolicyInputs)(packageInfo).length > 0 : false);

  // Only show API references tab if it is allowed & has documentation to show
  const showDocumentationTab = !_constants.HIDDEN_API_REFERENCE_PACKAGES.includes(pkgName) && packageInfo && (0, _documentation.hasDocumentation)({
    packageInfo,
    integration
  });

  // Track install status state
  (0, _react.useEffect)(() => {
    if (packageInfoIsFetchedAfterMount && packageInfoData !== null && packageInfoData !== void 0 && packageInfoData.item) {
      const packageInfoResponse = packageInfoData.item;
      setPackageInfo(packageInfoResponse);
      let installedVersion;
      const {
        name
      } = packageInfoData.item;
      if ('installationInfo' in packageInfoResponse) {
        var _packageInfoResponse$;
        installedVersion = (_packageInfoResponse$ = packageInfoResponse.installationInfo) === null || _packageInfoResponse$ === void 0 ? void 0 : _packageInfoResponse$.version;
      }
      const status = packageInfoResponse === null || packageInfoResponse === void 0 ? void 0 : packageInfoResponse.status;
      if (name) {
        setPackageInstallStatus({
          name,
          status,
          version: installedVersion || null
        });
      }
    }
  }, [packageInfoData, packageInfoIsFetchedAfterMount, setPackageInstallStatus, setPackageInfo]);
  const integrationInfo = (0, _react.useMemo)(() => {
    var _packageInfo$policy_t;
    return integration ? packageInfo === null || packageInfo === void 0 ? void 0 : (_packageInfo$policy_t = packageInfo.policy_templates) === null || _packageInfo$policy_t === void 0 ? void 0 : _packageInfo$policy_t.find(policyTemplate => policyTemplate.name === integration) : undefined;
  }, [integration, packageInfo]);
  const fromIntegrations = getFromIntegrations();
  const href = fromIntegrations === 'updates_available' ? getHref('integrations_installed_updates_available') : fromIntegrations === 'installed' ? getHref('integrations_installed') : getHref('integrations_all');
  const numOfDeferredInstallations = (0, _react.useMemo)(() => (0, _has_deferred_installations.getDeferredInstallationsCnt)(packageInfo), [packageInfo]);
  const headerLeftContent = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    "data-test-subj": "headerLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_components2.BackLink, {
    queryParams: queryParams,
    href: href
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(FlexItemWithMaxHeight, {
    grow: false
  }, isLoading || !packageInfo ? /*#__PURE__*/_react.default.createElement(_components2.LoadingIconPanel, null) : /*#__PURE__*/_react.default.createElement(_components2.IconPanel, {
    packageName: packageInfo.name,
    integrationName: integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.name,
    version: packageInfo.version,
    icons: (integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.icons) || packageInfo.icons
  })), /*#__PURE__*/_react.default.createElement(FlexItemWithMinWidth, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    justifyContent: "flexStart",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h1", null, (integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.title) || (packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.title) || '\u00A0'))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "default"
  }, _i18n.i18n.translate('xpack.fleet.epm.elasticAgentBadgeLabel', {
    defaultMessage: 'Elastic Agent'
  }))), packageInfo !== null && packageInfo !== void 0 && packageInfo.release && packageInfo.release !== 'ga' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_components.HeaderReleaseBadge, {
    release: (0, _services.getPackageReleaseLabel)(packageInfo.version)
  })) : null))))))), [integrationInfo, isLoading, packageInfo, href, queryParams]);
  const handleAddIntegrationPolicyClick = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    // The object below, given to `createHref` is explicitly accessing keys of `location` in order
    // to ensure that dependencies to this `useCallback` is set correctly (because `location` is mutable)
    const currentPath = history.createHref({
      pathname,
      search,
      hash
    });
    const navigateOptions = (0, _utils.getInstallPkgRouteOptions)({
      agentPolicyId: agentPolicyIdFromContext,
      currentPath,
      integration,
      isCloud,
      isExperimentalAddIntegrationPageEnabled,
      isFirstTimeAgentUser,
      isGuidedOnboardingActive,
      pkgkey
    });
    services.application.navigateToApp(...navigateOptions);
  }, [agentPolicyIdFromContext, hash, history, integration, isCloud, isExperimentalAddIntegrationPageEnabled, isFirstTimeAgentUser, isGuidedOnboardingActive, pathname, pkgkey, search, services.application]);
  const showVersionSelect = (0, _react.useMemo)(() => prereleaseIntegrationsEnabled && latestGAVersion && latestPrereleaseVersion && latestGAVersion !== latestPrereleaseVersion && (!(packageInfo !== null && packageInfo !== void 0 && packageInfo.version) || packageInfo.version === latestGAVersion || packageInfo.version === latestPrereleaseVersion), [prereleaseIntegrationsEnabled, latestGAVersion, latestPrereleaseVersion, packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.version]);
  const versionOptions = (0, _react.useMemo)(() => [{
    value: latestPrereleaseVersion,
    text: latestPrereleaseVersion
  }, {
    value: latestGAVersion,
    text: latestGAVersion
  }], [latestPrereleaseVersion, latestGAVersion]);
  const versionLabel = _i18n.i18n.translate('xpack.fleet.epm.versionLabel', {
    defaultMessage: 'Version'
  });
  const onVersionChange = (0, _react.useCallback)((version, packageName) => {
    const path = getPath('integration_details_overview', {
      pkgkey: `${packageName}-${version}`
    });
    history.push(path);
  }, [getPath, history]);
  const headerRightContent = (0, _react.useMemo)(() => packageInfo ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    direction: "row"
  }, [{
    label: showVersionSelect ? undefined : versionLabel,
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, showVersionSelect ? /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      "data-test-subj": "versionSelect",
      prepend: versionLabel,
      options: versionOptions,
      value: packageInfo.version,
      onChange: event => onVersionChange(event.target.value, packageInfo.name)
    }) : /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "versionText"
    }, packageInfo.version)), updateAvailable ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_components2.UpdateIcon, null)) : null)
  }, ...(isInstalled ? [{
    isDivider: true
  }, {
    label: _i18n.i18n.translate('xpack.fleet.epm.usedByLabel', {
      defaultMessage: 'Agent policies'
    }),
    'data-test-subj': 'agentPolicyCount',
    content: /*#__PURE__*/_react.default.createElement(_components2.IntegrationAgentPolicyCount, {
      packageName: packageInfo.name
    })
  }] : []), {
    isDivider: true
  }, {
    content: /*#__PURE__*/_react.default.createElement(_components.WithGuidedOnboardingTour, {
      packageKey: pkgkey,
      tourType: 'addIntegrationButton',
      isTourVisible: isOverviewPage && isGuidedOnboardingActive,
      tourOffset: 10
    }, /*#__PURE__*/_react.default.createElement(_components2.AddIntegrationButton, {
      userCanInstallPackages: userCanInstallPackages,
      href: getHref('add_integration_to_policy', {
        pkgkey,
        ...(integration ? {
          integration
        } : {}),
        ...(agentPolicyIdFromContext ? {
          agentPolicyId: agentPolicyIdFromContext
        } : {})
      }),
      missingSecurityConfiguration: missingSecurityConfiguration,
      packageName: (integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.title) || packageInfo.title,
      onClick: handleAddIntegrationPolicyClick
    }))
  }].map((item, index) => {
    var _item$isDivider;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: index,
      "data-test-subj": item['data-test-subj']
    }, ((_item$isDivider = item.isDivider) !== null && _item$isDivider !== void 0 ? _item$isDivider : false) ? /*#__PURE__*/_react.default.createElement(Divider, null) : item.label ? /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      className: "eui-textRight",
      compressed: true,
      textStyle: "reverse"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, item.label), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, item.content)) : item.content);
  }))) : undefined, [packageInfo, updateAvailable, isInstalled, pkgkey, isOverviewPage, isGuidedOnboardingActive, userCanInstallPackages, getHref, integration, agentPolicyIdFromContext, missingSecurityConfiguration, integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.title, handleAddIntegrationPolicyClick, onVersionChange, showVersionSelect, versionLabel, versionOptions]);
  const headerTabs = (0, _react.useMemo)(() => {
    if (!packageInfo) {
      return [];
    }
    const packageInfoKey = (0, _services2.pkgKeyFromPackageInfo)(packageInfo);
    const tabs = [{
      id: 'overview',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.packageDetailsNav.overviewLinkText",
        defaultMessage: "Overview"
      }),
      isSelected: panel === 'overview',
      'data-test-subj': `tab-overview`,
      href: getHref('integration_details_overview', {
        pkgkey: packageInfoKey,
        ...(integration ? {
          integration
        } : {})
      })
    }];
    if (canReadIntegrationPolicies && isInstalled) {
      tabs.push({
        id: 'policies',
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epm.packageDetailsNav.packagePoliciesLinkText",
          defaultMessage: "Integration policies"
        }),
        isSelected: panel === 'policies',
        'data-test-subj': `tab-policies`,
        href: getHref('integration_details_policies', {
          pkgkey: packageInfoKey,
          ...(integration ? {
            integration
          } : {})
        })
      });
    }
    if (isInstalled && (packageInfo.assets || CustomAssets)) {
      tabs.push({
        id: 'assets',
        name: /*#__PURE__*/_react.default.createElement("div", {
          style: {
            display: 'flex',
            textAlign: 'center'
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epm.packageDetailsNav.packageAssetsLinkText",
          defaultMessage: "Assets"
        }), "\xA0", numOfDeferredInstallations > 0 ? /*#__PURE__*/_react.default.createElement(_deferred_assets_warning.DeferredAssetsWarning, {
          numOfDeferredInstallations: numOfDeferredInstallations
        }) : null),
        isSelected: panel === 'assets',
        'data-test-subj': `tab-assets`,
        href: getHref('integration_details_assets', {
          pkgkey: packageInfoKey,
          ...(integration ? {
            integration
          } : {})
        })
      });
    }
    if (canReadPackageSettings) {
      tabs.push({
        id: 'settings',
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epm.packageDetailsNav.settingsLinkText",
          defaultMessage: "Settings"
        }),
        isSelected: panel === 'settings',
        'data-test-subj': `tab-settings`,
        href: getHref('integration_details_settings', {
          pkgkey: packageInfoKey,
          ...(integration ? {
            integration
          } : {})
        })
      });
    }
    if (canReadPackageSettings && showConfigTab) {
      tabs.push({
        id: 'configs',
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epm.packageDetailsNav.configsText",
          defaultMessage: "Configs"
        }),
        isSelected: panel === 'configs',
        'data-test-subj': `tab-configs`,
        href: getHref('integration_details_configs', {
          pkgkey: packageInfoKey,
          ...(integration ? {
            integration
          } : {})
        })
      });
    }
    if (canReadPackageSettings && showCustomTab) {
      tabs.push({
        id: 'custom',
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epm.packageDetailsNav.packageCustomLinkText",
          defaultMessage: "Advanced"
        }),
        isSelected: panel === 'custom',
        'data-test-subj': `tab-custom`,
        href: getHref('integration_details_custom', {
          pkgkey: packageInfoKey,
          ...(integration ? {
            integration
          } : {})
        })
      });
    }
    if (showDocumentationTab) {
      tabs.push({
        id: 'api-reference',
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epm.packageDetailsNav.documentationLinkText",
          defaultMessage: "API reference"
        }),
        isSelected: panel === 'api-reference',
        'data-test-subj': `tab-api-reference`,
        href: getHref('integration_details_api_reference', {
          pkgkey: packageInfoKey,
          ...(integration ? {
            integration
          } : {})
        })
      });
    }
    return tabs;
  }, [packageInfo, panel, getHref, integration, canReadIntegrationPolicies, isInstalled, CustomAssets, canReadPackageSettings, showConfigTab, showCustomTab, showDocumentationTab, numOfDeferredInstallations]);
  const securityCallout = missingSecurityConfiguration ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "lock",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epm.packageDetailsSecurityRequiredCalloutTitle",
      defaultMessage: "Security needs to be enabled in order to add Elastic Agent integrations"
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.packageDetailsSecurityRequiredCalloutDescription",
    defaultMessage: "In order to fully use Fleet, you must enable Elasticsearch and Kibana security features. Follow the {guideLink} to enable security.",
    values: {
      guideLink: /*#__PURE__*/_react.default.createElement("a", {
        href: services.http.basePath.prepend('/app/fleet')
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.packageDetailsSecurityRequiredCalloutDescriptionGuideLink",
        defaultMessage: "steps in this guide"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : undefined;
  return /*#__PURE__*/_react.default.createElement(_layouts.WithHeaderLayout, {
    leftColumn: headerLeftContent,
    rightColumn: headerRightContent,
    rightColumnGrow: false,
    topContent: securityCallout,
    tabs: headerTabs,
    tabsClassName: "fleet__epm__shiftNavTabs"
  }, integrationInfo || packageInfo ? /*#__PURE__*/_react.default.createElement(Breadcrumbs, {
    packageTitle: (integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.title) || (packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.title) || ''
  }) : null, packageInfoError ? /*#__PURE__*/_react.default.createElement(_components.Error, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epm.loadingIntegrationErrorTitle",
      defaultMessage: "Error loading integration details"
    }),
    error: packageInfoError.message
  }) : isLoading || !packageInfo ? /*#__PURE__*/_react.default.createElement(_components.Loading, null) : /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants2.INTEGRATIONS_ROUTING_PATHS.integration_details_overview
  }, /*#__PURE__*/_react.default.createElement(_overview.OverviewPage, {
    packageInfo: packageInfo,
    integrationInfo: integrationInfo,
    latestGAVersion: latestGAVersion
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants2.INTEGRATIONS_ROUTING_PATHS.integration_details_settings
  }, /*#__PURE__*/_react.default.createElement(_settings.SettingsPage, {
    packageInfo: packageInfo,
    startServices: services
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants2.INTEGRATIONS_ROUTING_PATHS.integration_details_assets
  }, /*#__PURE__*/_react.default.createElement(_assets.AssetsPage, {
    packageInfo: packageInfo,
    refetchPackageInfo: refetchPackageInfo
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants2.INTEGRATIONS_ROUTING_PATHS.integration_details_configs
  }, /*#__PURE__*/_react.default.createElement(_configs.Configs, {
    packageInfo: packageInfo
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants2.INTEGRATIONS_ROUTING_PATHS.integration_details_policies
  }, /*#__PURE__*/_react.default.createElement(_policies.PackagePoliciesPage, {
    name: packageInfo.name,
    version: packageInfo.version
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants2.INTEGRATIONS_ROUTING_PATHS.integration_details_custom
  }, /*#__PURE__*/_react.default.createElement(_custom.CustomViewPage, {
    packageInfo: packageInfo
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants2.INTEGRATIONS_ROUTING_PATHS.integration_details_api_reference
  }, /*#__PURE__*/_react.default.createElement(_documentation.DocumentationPage, {
    packageInfo: packageInfo,
    integration: integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.name
  })), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: _constants2.INTEGRATIONS_ROUTING_PATHS.integration_details_overview
  })));
}