"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasDocumentation = exports.DocumentationPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../../../../hooks");
var _services = require("../../../../../../../../common/services");
var _side_bar_column = require("../../../components/side_bar_column");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getInputs = ({
  packageInfo,
  integration
}) => {
  var _packageInfo$policy_t;
  return (_packageInfo$policy_t = packageInfo.policy_templates) === null || _packageInfo$policy_t === void 0 ? void 0 : _packageInfo$policy_t.reduce((acc, policyTemplate) => {
    if (integration && policyTemplate.name !== integration) {
      return acc;
    }
    if ('inputs' in policyTemplate && policyTemplate.inputs) {
      return [...acc, ...policyTemplate.inputs.map(input => ({
        key: `${policyTemplate.name}-${input.type}`,
        ...input,
        streams: (0, _services.getStreamsForInputType)(input.type, packageInfo, [])
      }))];
    }
    return acc;
  }, []);
};
const hasDocumentation = ({
  packageInfo,
  integration
}) => {
  if (packageInfo.vars && packageInfo.vars.length > 0) {
    return true;
  }
  if ((getInputs({
    packageInfo,
    integration
  }) || []).length > 0) {
    return true;
  }
};
exports.hasDocumentation = hasDocumentation;
const DocumentationPage = ({
  packageInfo,
  integration
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const showDocumentation = hasDocumentation({
    packageInfo,
    integration
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_side_bar_column.SideBarColumn, {
    grow: 1
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.packageDetails.apiReference.description",
    defaultMessage: "This documents all the inputs, streams, and variables available to use this integration programmatically via the Fleet Kibana API. {learnMore}",
    values: {
      learnMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.api,
        external: true
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.packageDetails.apiReference.learnMoreLink",
        defaultMessage: "Learn more"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), showDocumentation ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(PackageVars, {
    vars: packageInfo.vars
  }), /*#__PURE__*/_react.default.createElement(Inputs, {
    packageInfo: packageInfo,
    integration: integration
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epm.packageDetails.apiReference.noDocumentationMessage",
      defaultMessage: "This integration has no references available."
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })));
};
exports.DocumentationPage = DocumentationPage;
const StreamsSection = ({
  streams
}) => {
  if (streams.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h6", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.packageDetails.apiReference.streamsTitle",
    defaultMessage: "Streams"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), streams.map(dataStream => /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    key: dataStream.data_stream.type + dataStream.data_stream.dataset,
    id: dataStream.data_stream.type + dataStream.data_stream.dataset,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, dataStream.data_stream.dataset), "(", dataStream.title, ")"),
    initialIsOpen: false,
    paddingSize: 'm'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, dataStream.description), dataStream.vars ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(VarsTable, {
    vars: dataStream.vars
  })) : null)));
};
const Inputs = ({
  packageInfo,
  integration
}) => {
  var _inputs$map;
  const inputs = (0, _react.useMemo)(() => getInputs({
    packageInfo,
    integration
  }), [packageInfo, integration]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.packageDetails.apiReference.inputsTitle",
    defaultMessage: "Inputs"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), (_inputs$map = inputs === null || inputs === void 0 ? void 0 : inputs.map(input => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      key: input.key,
      id: input.key,
      buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, input.key), "(", input.title, ")"),
      initialIsOpen: false,
      paddingSize: 'm'
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, input.description), input.vars ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(VarsTable, {
      vars: input.vars
    })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(StreamsSection, {
      streams: input.streams
    }));
  })) !== null && _inputs$map !== void 0 ? _inputs$map : null);
};
const PackageVars = ({
  vars
}) => {
  if (!vars) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.packageDetails.apiReference.globalVariablesTitle",
    defaultMessage: "Package variables"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(VarsTable, {
    vars: vars
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
const VarsTable = ({
  vars
}) => {
  const columns = (0, _react.useMemo)(() => {
    return [{
      field: 'name',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.packageDetails.apiReference.columnKeyName",
        defaultMessage: "Key"
      }),
      render: name => /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, name)
    }, {
      field: 'title',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.packageDetails.apiReference.columnTitleName",
        defaultMessage: "Title"
      })
    }, {
      field: 'type',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.packageDetails.apiReference.columnTypeName",
        defaultMessage: "Type"
      })
    }, {
      field: 'required',
      width: '70px',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.packageDetails.apiReference.columnRequiredName",
        defaultMessage: "Required"
      })
    }, {
      field: 'multi',
      width: '70px',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.packageDetails.apiReference.columnMultidName",
        defaultMessage: "Multi"
      })
    }];
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h6", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.packageDetails.apiReference.variableTableTitle",
    defaultMessage: "Variables"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: vars
  }));
};