"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BackLink = BackLink;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function BackLink({
  queryParams,
  href: integrationsHref
}) {
  const {
    onboardingLink
  } = (0, _react.useMemo)(() => {
    return {
      onboardingLink: queryParams.get('observabilityOnboardingLink')
    };
  }, [queryParams]);
  const href = onboardingLink !== null && onboardingLink !== void 0 ? onboardingLink : integrationsHref;
  const message = onboardingLink ? BACK_TO_SELECTION : BACK_TO_INTEGRATIONS;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "arrowLeft",
    size: "xs",
    flush: "left",
    href: href
  }, message);
}
const BACK_TO_INTEGRATIONS = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.epm.browseAllButtonText",
  defaultMessage: "Back to integrations"
});
const BACK_TO_SELECTION = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.epm.returnToObservabilityOnboarding",
  defaultMessage: "Back to selection"
});