"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackageCard = PackageCard;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _public = require("@kbn/usage-collection-plugin/public");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _deferred_assets_warning = require("../screens/detail/assets/deferred_assets_warning");
var _package_icon = require("../../../../../components/package_icon");
var _components = require("../../../components");
var _hooks = require("../../../hooks");
var _constants = require("../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Min-height is roughly 3 lines of content.
// This keeps the cards from looking overly unbalanced because of content differences.
const Card = (0, _styledComponents.default)(_eui.EuiCard)`
  min-height: 127px;
  border-color: ${({
  isquickstart
}) => isquickstart ? '#ba3d76' : null};
`;
function PackageCard({
  description,
  name,
  title,
  version,
  icons,
  integration,
  url,
  release,
  id,
  fromIntegrations,
  isReauthorizationRequired,
  isUnverified,
  isUpdateAvailable,
  showLabels = true,
  extraLabelsBadges,
  isQuickstart = false,
  onCardClick: onClickProp = undefined,
  isCollectionCard = false
}) {
  let releaseBadge = null;
  if (release && release !== 'ga') {
    releaseBadge = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_components.InlineReleaseBadge, {
      release: release
    })));
  }
  let verifiedBadge = null;
  if (isUnverified && showLabels) {
    verifiedBadge = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "warning"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.packageCard.unverifiedLabel",
      defaultMessage: "Unverified"
    }))));
  }
  let hasDeferredInstallationsBadge = null;
  if (isReauthorizationRequired && showLabels) {
    hasDeferredInstallationsBadge = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      display: "inlineBlock",
      content: _deferred_assets_warning.DEFERRED_ASSETS_WARNING_MSG,
      title: _deferred_assets_warning.DEFERRED_ASSETS_WARNING_LABEL
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "warning"
    }, _deferred_assets_warning.DEFERRED_ASSETS_WARNING_LABEL, " "))));
  }
  let updateAvailableBadge = null;
  if (isUpdateAvailable && showLabels) {
    updateAvailableBadge = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      iconType: "sortUp"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.packageCard.updateAvailableLabel",
      defaultMessage: "Update available"
    }))));
  }
  let collectionButton = null;
  if (isCollectionCard) {
    collectionButton = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "text",
      "data-test-subj": "xpack.fleet.packageCard.collectionButton",
      iconType: "package"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.packageCard.collectionButton.copy",
      defaultMessage: "View collection"
    })));
  }
  const {
    application
  } = (0, _hooks.useStartServices)();
  const isGuidedOnboardingActive = (0, _hooks.useIsGuidedOnboardingActive)(name);
  const onCardClick = () => {
    if (url.startsWith(_constants.INTEGRATIONS_BASE_PATH)) {
      application.navigateToApp(_constants.INTEGRATIONS_PLUGIN_ID, {
        path: url.slice(_constants.INTEGRATIONS_BASE_PATH.length),
        state: {
          fromIntegrations
        }
      });
    } else if (url.startsWith('http') || url.startsWith('https')) {
      window.open(url, '_blank');
    } else {
      application.navigateToUrl(url);
    }
  };
  const testid = `integration-card:${id}`;
  return /*#__PURE__*/_react.default.createElement(_components.WithGuidedOnboardingTour, {
    packageKey: name,
    isTourVisible: isGuidedOnboardingActive,
    tourType: 'integrationCard',
    tourOffset: 10
  }, /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
    viewId: testid
  }, /*#__PURE__*/_react.default.createElement(Card
  // EUI TODO: Custom component CSS
  , {
    css: (0, _react2.css)`
            [class*='euiCard__content'] {
              display: flex;
              flex-direction: column;
              block-size: 100%;
            }

            [class*='euiCard__description'] {
              flex-grow: 1;
            }
          `,
    "data-test-subj": testid,
    isquickstart: isQuickstart,
    betaBadgeProps: quickstartBadge(isQuickstart),
    layout: "horizontal",
    title: title || '',
    titleSize: "xs",
    description: description,
    hasBorder: true,
    icon: /*#__PURE__*/_react.default.createElement(_package_icon.CardIcon, {
      icons: icons,
      packageName: name,
      integrationName: integration,
      version: version,
      size: "xl"
    }),
    onClick: onClickProp !== null && onClickProp !== void 0 ? onClickProp : onCardClick
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    wrap: true
  }, showLabels && extraLabelsBadges ? extraLabelsBadges : null, verifiedBadge, updateAvailableBadge, releaseBadge, hasDeferredInstallationsBadge, collectionButton))));
}
function quickstartBadge(isQuickstart) {
  return isQuickstart ? {
    label: _i18n.i18n.translate('xpack.fleet.packageCard.quickstartBadge.label', {
      defaultMessage: 'Quickstart'
    }),
    color: 'accent'
  } : undefined;
}