"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentUnenrollAgentModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentUnenrollAgentModal = ({
  onClose,
  agents,
  agentCount,
  useForceUnenroll,
  hasFleetServer = false
}) => {
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const [forceUnenroll, setForceUnenroll] = (0, _react.useState)(useForceUnenroll || false);
  const [isSubmitting, setIsSubmitting] = (0, _react.useState)(false);
  const isSingleAgent = Array.isArray(agents) && agents.length === 1;
  async function onSubmit() {
    try {
      setIsSubmitting(true);
      const {
        error
      } = isSingleAgent ? await (0, _hooks.sendPostAgentUnenroll)(agents[0].id, {
        revoke: forceUnenroll
      }) : await (0, _hooks.sendPostBulkAgentUnenroll)({
        agents: Array.isArray(agents) ? agents.map(agent => agent.id) : agents,
        revoke: forceUnenroll,
        // includeInactive is only used when the agents are selected by query, it's ignored in the case of agent ids
        includeInactive: true
      });
      if (error) {
        throw error;
      }
      setIsSubmitting(false);
      if (forceUnenroll) {
        const successMessage = isSingleAgent ? _i18n.i18n.translate('xpack.fleet.unenrollAgents.successForceSingleNotificationTitle', {
          defaultMessage: 'Agent unenrolled'
        }) : _i18n.i18n.translate('xpack.fleet.unenrollAgents.successForceMultiNotificationTitle', {
          defaultMessage: 'Agents unenrolled'
        });
        notifications.toasts.addSuccess(successMessage);
      } else {
        const successMessage = isSingleAgent ? _i18n.i18n.translate('xpack.fleet.unenrollAgents.successSingleNotificationTitle', {
          defaultMessage: 'Unenrolling agent'
        }) : _i18n.i18n.translate('xpack.fleet.unenrollAgents.successMultiNotificationTitle', {
          defaultMessage: 'Unenrolling agents'
        });
        notifications.toasts.addSuccess(successMessage);
      }
      onClose();
    } catch (error) {
      setIsSubmitting(false);
      notifications.toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.fleet.unenrollAgents.fatalErrorNotificationTitle', {
          defaultMessage: 'Error unenrolling {count, plural, one {agent} other {agents}}',
          values: {
            count: agentCount
          }
        })
      });
    }
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "data-test-subj": "agentUnenrollModal",
    title: isSingleAgent ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.unenrollAgents.deleteSingleTitle",
      defaultMessage: "Unenroll agent"
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.unenrollAgents.forceDeleteMultipleTitle",
      defaultMessage: "Unenroll {count} agents",
      values: {
        count: agentCount
      }
    }),
    onCancel: onClose,
    onConfirm: onSubmit,
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.unenrollAgents.cancelButtonLabel",
      defaultMessage: "Cancel"
    }),
    confirmButtonDisabled: isSubmitting,
    confirmButtonText: isSingleAgent ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.unenrollAgents.confirmSingleButtonLabel",
      defaultMessage: "Unenroll agent"
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.unenrollAgents.confirmMultipleButtonLabel",
      defaultMessage: "Unenroll {count} agents",
      values: {
        count: agentCount
      }
    }),
    buttonColor: "danger"
  }, /*#__PURE__*/_react.default.createElement("p", null, hasFleetServer && isSingleAgent ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.unenrollAgents.unenrollFleetServerTitle', {
      defaultMessage: 'This agent is running Fleet Server'
    }),
    color: "warning",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.unenrollAgents.unenrollFleetServerDescription",
    defaultMessage: "Unenrolling this agent will disconnect a Fleet Server and prevent agents from sending data if no other Fleet Servers exist."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null, isSingleAgent ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.unenrollAgents.deleteSingleDescription",
    defaultMessage: "This action will remove the selected agent running on \"{hostName}\" from Fleet. Any data that was already sent by the agent will not be deleted. This action cannot be undone.",
    values: {
      hostName: agents[0].local_metadata.host.hostname
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.unenrollAgents.deleteMultipleDescription",
    defaultMessage: "This action will remove multiple agents from Fleet and prevent new data from being ingested. Any data that was already sent by these agents will not be affected. This action cannot be undone."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormFieldset, {
    legend: {
      children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.unenrollAgents.forceUnenrollLegendText",
        defaultMessage: "Force unenroll {count, plural, one {agent} other {agents}}",
        values: {
          count: agentCount
        }
      })
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "fleetForceUnenrollAgents",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.unenrollAgents.forceUnenrollCheckboxLabel",
      defaultMessage: "Remove {count, plural, one {agent} other {agents}} immediately. Do not wait for agent to send any last data.",
      values: {
        count: agentCount
      }
    }),
    checked: forceUnenroll,
    onChange: e => setForceUnenroll(e.target.checked),
    disabled: useForceUnenroll
  })));
};
exports.AgentUnenrollAgentModal = AgentUnenrollAgentModal;