"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentListTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _services = require("../../../../services");
var _components = require("../../components");
var _hooks = require("../../../../hooks");
var _components2 = require("../../../../components");
var _tags = require("../../components/tags");
var _agent_metrics = require("../../services/agent_metrics");
var _agent_upgrade_status = require("./agent_upgrade_status");
var _empty_prompt = require("./empty_prompt");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VERSION_FIELD = 'local_metadata.elastic.agent.version';
const HOSTNAME_FIELD = 'local_metadata.host.hostname';
function safeMetadata(val) {
  if (typeof val !== 'string') {
    return '-';
  }
  return val;
}
const AgentListTable = props => {
  const {
    agents,
    isLoading,
    agentPoliciesIndexedById,
    renderActions,
    sortField,
    sortOrder,
    onTableChange,
    onSelectionChange,
    selected,
    totalAgents = 0,
    showUpgradeable,
    pagination,
    pageSizeOptions,
    isUsingFilter,
    setEnrollmentFlyoutState,
    clearFilters,
    isCurrentRequestIncremented
  } = props;
  const authz = (0, _hooks.useAuthz)();
  const {
    displayAgentMetrics
  } = _services.ExperimentalFeaturesService.get();
  const {
    getHref
  } = (0, _hooks.useLink)();
  const latestAgentVersion = (0, _hooks.useAgentVersion)();
  const isAgentSelectable = agent => {
    if (!agent.active) return false;
    if (!agent.policy_id) return true;
    const agentPolicy = agentPoliciesIndexedById[agent.policy_id];
    const isHosted = (agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.is_managed) === true;
    return !isHosted;
  };
  const noItemsMessage = isLoading && isCurrentRequestIncremented ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.loadingAgentsMessage",
    defaultMessage: "Loading agents\u2026"
  }) : isUsingFilter ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.noFilteredAgentsPrompt",
    defaultMessage: "No agents found. {clearFiltersLink}",
    values: {
      clearFiltersLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: () => clearFilters()
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentList.clearFiltersLinkText",
        defaultMessage: "Clear filters"
      }))
    }
  }) : /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
    hasFleetAddAgentsPrivileges: authz.fleet.addAgents,
    setEnrollmentFlyoutState: setEnrollmentFlyoutState
  });
  const sorting = {
    sort: {
      field: sortField,
      direction: sortOrder
    }
  };
  const columns = [{
    field: 'active',
    sortable: false,
    width: '85px',
    name: _i18n.i18n.translate('xpack.fleet.agentList.statusColumnTitle', {
      defaultMessage: 'Status'
    }),
    render: (active, agent) => /*#__PURE__*/_react.default.createElement(_components.AgentHealth, {
      agent: agent
    })
  }, {
    field: HOSTNAME_FIELD,
    sortable: true,
    name: _i18n.i18n.translate('xpack.fleet.agentList.hostColumnTitle', {
      defaultMessage: 'Host'
    }),
    width: '185px',
    render: (host, agent) => {
      var _agent$tags;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "none",
        direction: "column"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: getHref('agent_details', {
          agentId: agent.id
        })
      }, safeMetadata(host))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_tags.Tags, {
        tags: (_agent$tags = agent.tags) !== null && _agent$tags !== void 0 ? _agent$tags : [],
        color: "subdued",
        size: "xs"
      })));
    }
  }, {
    field: 'policy_id',
    sortable: true,
    truncateText: true,
    name: _i18n.i18n.translate('xpack.fleet.agentList.policyColumnTitle', {
      defaultMessage: 'Agent policy'
    }),
    width: '185px',
    render: (policyId, agent) => {
      const agentPolicy = agentPoliciesIndexedById[policyId];
      const showWarning = agent.policy_revision && (agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.revision) > agent.policy_revision;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "m",
        style: {
          minWidth: 0
        },
        alignItems: "center"
      }, agentPolicy && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_components2.AgentPolicySummaryLine, {
        direction: "column",
        policy: agentPolicy,
        agent: agent
      })), showWarning && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued",
        size: "xs",
        className: "eui-textNoWrap"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "m",
        type: "warning",
        color: "warning"
      }), "\xA0", /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentList.outOfDateLabel",
        defaultMessage: "Outdated policy"
      }))));
    }
  }, ...(displayAgentMetrics ? [{
    field: 'metrics',
    sortable: false,
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentList.cpuTooltip",
        defaultMessage: "Average CPU usage in the last 5 minutes. This includes usage from the Agent and the component it supervises. Possible value ranges from 0 to (number of available CPU cores * 100)"
      })
    }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.cpuTitle",
      defaultMessage: "CPU"
    }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "iInCircle"
    }))),
    width: '75px',
    render: (metrics, agent) => (0, _agent_metrics.formatAgentCPU)(agent.metrics, agent.policy_id ? agentPoliciesIndexedById[agent.policy_id] : undefined)
  }, {
    field: 'metrics',
    sortable: false,
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentList.memoryTooltip",
        defaultMessage: "Average memory usage in the last 5 minutes"
      })
    }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.memoryTitle",
      defaultMessage: "Memory"
    }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "iInCircle"
    }))),
    width: '90px',
    render: (metrics, agent) => (0, _agent_metrics.formatAgentMemory)(agent.metrics, agent.policy_id ? agentPoliciesIndexedById[agent.policy_id] : undefined)
  }] : []), {
    field: 'last_checkin',
    sortable: true,
    name: _i18n.i18n.translate('xpack.fleet.agentList.lastCheckinTitle', {
      defaultMessage: 'Last activity'
    }),
    width: '180px',
    render: (lastCheckin, agent) => lastCheckin ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
      value: lastCheckin
    }) : null
  }, {
    field: VERSION_FIELD,
    sortable: true,
    width: '180px',
    name: _i18n.i18n.translate('xpack.fleet.agentList.versionTitle', {
      defaultMessage: 'Version'
    }),
    render: (version, agent) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      style: {
        minWidth: 0
      },
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      className: "eui-textNoWrap"
    }, safeMetadata(version))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_agent_upgrade_status.AgentUpgradeStatus, {
      isAgentUpgradable: !!(isAgentSelectable(agent) && (0, _services.isAgentUpgradeable)(agent)),
      agent: agent,
      latestAgentVersion: latestAgentVersion
    })))))
  }, {
    name: _i18n.i18n.translate('xpack.fleet.agentList.actionsColumnTitle', {
      defaultMessage: 'Actions'
    }),
    actions: [{
      render: renderActions
    }],
    width: '100px'
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    className: "fleet__agentList__table",
    "data-test-subj": "fleetAgentListTable",
    loading: isLoading,
    noItemsMessage: noItemsMessage,
    items: totalAgents ? showUpgradeable ? agents.filter(agent => isAgentSelectable(agent) && (0, _services.isAgentUpgradeable)(agent)) : agents : [],
    itemId: "id",
    columns: columns,
    pagination: {
      pageIndex: pagination.currentPage - 1,
      pageSize: pagination.pageSize,
      totalItemCount: totalAgents,
      pageSizeOptions
    },
    selection: !authz.fleet.allAgents ? undefined : {
      selected,
      onSelectionChange,
      selectable: isAgentSelectable,
      selectableMessage: (selectable, agent) => {
        if (selectable) return '';
        if (!agent.active) {
          return 'This agent is not active';
        }
        if (agent.policy_id && agentPoliciesIndexedById[agent.policy_id].is_managed) {
          return 'This action is not available for agents enrolled in an externally managed agent policy';
        }
        return '';
      }
    },
    onChange: onTableChange,
    sorting: sorting
  });
};
exports.AgentListTable = AgentListTable;