"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewAgentsButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_VIEW_AGENTS_COUNT = 1000;
const ViewAgentsButton = ({
  action,
  onClickViewAgents,
  agentPolicies
}) => {
  const isDisabled = (0, _react.useMemo)(() => {
    var _agentPolicies$find;
    if (action.type !== 'POLICY_CHANGE') {
      return action.nbAgentsActionCreated > MAX_VIEW_AGENTS_COUNT;
    }
    const actionPolicyId = action.actionId.split(':')[0];
    return (agentPolicies === null || agentPolicies === void 0 ? void 0 : (_agentPolicies$find = agentPolicies.find(agentPolicy => agentPolicy.id === actionPolicyId)) === null || _agentPolicies$find === void 0 ? void 0 : _agentPolicies$find.agents) === 0;
  }, [action, agentPolicies]);
  if (action.type === 'UPDATE_TAGS') {
    return null;
  }
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "m",
    onClick: () => onClickViewAgents(action),
    flush: "left",
    "data-test-subj": "agentActivityFlyout.viewAgentsButton",
    disabled: isDisabled
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentActivityFlyout.viewAgentsButton",
    defaultMessage: "View Agents"
  }));
  if (action.type !== 'POLICY_CHANGE' && !isDisabled) {
    return button;
  }
  if (action.type === 'POLICY_CHANGE') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentActivityFlyout.viewAgentsButtonPolicyChangeTooltip",
        defaultMessage: "View agents currently assigned to this policy"
      })
    }, button);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentActivityFlyout.viewAgentsButtonDisabledMaxTooltip",
      defaultMessage: "The view agents feature is only available for action impacting less than {agentCount} agents",
      values: {
        agentCount: MAX_VIEW_AGENTS_COUNT
      }
    })
  }, button);
};
exports.ViewAgentsButton = ViewAgentsButton;