"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutBody = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _components = require("../../../components");
var _activity_section = require("./activity_section");
var _go_to_date = require("./go_to_date");
var _agent_activity_helper = require("./agent_activity_helper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FullHeightFlyoutBody = (0, _styledComponents.default)(_eui.EuiFlyoutBody)`
  .euiFlyoutBody__overflowContent {
    height: 100%;
  }
`;
const ButtonsFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  padding-left: 24px;
`;
const ScrollAnchor = _styledComponents.default.div`
  height: 0;
  margin: 0;
  padding: 0;
`;
const FlyoutBody = ({
  isFirstLoading,
  currentActions,
  abortUpgrade,
  onClickViewAgents,
  areActionsFullyLoaded,
  onClickShowMore,
  dateFilter,
  onChangeDateFilter,
  agentPolicies
}) => {
  const scrollToTopRef = _react.default.useRef(null);
  _react.default.useEffect(() => {
    var _scrollToTopRef$curre;
    // Condition needed for jest tests as scrollIntoView is not implemented in jsdom
    if ((_scrollToTopRef$curre = scrollToTopRef.current) !== null && _scrollToTopRef$curre !== void 0 && _scrollToTopRef$curre.scrollIntoView) {
      scrollToTopRef.current.scrollIntoView();
    }
  }, [dateFilter]);
  // Loading
  if (isFirstLoading) {
    return /*#__PURE__*/_react.default.createElement(FullHeightFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      justifyContent: 'center',
      alignItems: 'center',
      className: "eui-fullHeight"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_components.Loading, null))));
  }

  // No actions
  if (currentActions.length === 0) {
    return /*#__PURE__*/_react.default.createElement(FullHeightFlyoutBody, null, /*#__PURE__*/_react.default.createElement(ScrollAnchor, {
      ref: scrollToTopRef
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      justifyContent: 'center',
      alignItems: 'center',
      className: "eui-fullHeight"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "clock",
      iconColor: "default",
      title: /*#__PURE__*/_react.default.createElement("h2", null, ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentActivityFlyout.noActivityText",
        defaultMessage: "No activity to display"
      })),
      titleSize: "m",
      body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentActivityFlyout.noActivityDescription",
        defaultMessage: "Activity feed will appear here as agents are reassigned, upgraded, or unenrolled."
      })
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_go_to_date.GoToDate, {
      selectedDate: dateFilter,
      onChangeSelectedDate: onChangeDateFilter,
      filledStyle: true
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: () => onChangeDateFilter(null)
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentActivityFlyout.emptyState.showMoreButton",
      defaultMessage: "Clear selected date"
    })))));
  }

  // Loaded actions
  const inProgressActions = currentActions.filter(a => a.status === 'IN_PROGRESS');
  const completedActions = currentActions.filter(a => a.status !== 'IN_PROGRESS');
  const todayActions = (0, _agent_activity_helper.getTodayActions)(completedActions);
  const otherDays = (0, _agent_activity_helper.getOtherDaysActions)(completedActions);
  return /*#__PURE__*/_react.default.createElement(FullHeightFlyoutBody, null, /*#__PURE__*/_react.default.createElement(ScrollAnchor, {
    ref: scrollToTopRef
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, inProgressActions.length > 0 ? /*#__PURE__*/_react.default.createElement(_activity_section.ActivitySection, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentActivityFlyout.inProgressTitle",
      defaultMessage: "In progress"
    }),
    actions: inProgressActions,
    abortUpgrade: abortUpgrade,
    onClickViewAgents: onClickViewAgents,
    agentPolicies: agentPolicies
  }) : null, todayActions.length > 0 ? /*#__PURE__*/_react.default.createElement(_activity_section.ActivitySection, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentActivityFlyout.todayTitle",
      defaultMessage: "Today"
    }),
    actions: todayActions,
    abortUpgrade: abortUpgrade,
    onClickViewAgents: onClickViewAgents,
    agentPolicies: agentPolicies
  }) : null, Object.keys(otherDays).map(day => /*#__PURE__*/_react.default.createElement(_activity_section.ActivitySection, {
    key: day,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
      value: day,
      year: "numeric",
      month: "short",
      day: "2-digit"
    }),
    actions: otherDays[day],
    abortUpgrade: abortUpgrade,
    onClickViewAgents: onClickViewAgents,
    agentPolicies: agentPolicies
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(ButtonsFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "m",
    onClick: onClickShowMore,
    disabled: areActionsFullyLoaded,
    flush: "left",
    "data-test-subj": "agentActivityFlyout.showMoreButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentActivityFlyout.showMoreButton",
    defaultMessage: "Show more"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_go_to_date.GoToDate, {
    selectedDate: dateFilter,
    onChangeSelectedDate: onChangeDateFilter,
    filledStyle: false
  })), dateFilter && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "m",
    onClick: () => onChangeDateFilter(null),
    flush: "left",
    "data-test-subj": "agentActivityFlyout.clearSelectedDateButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentActivityFlyout.clearSelectedDateutton",
    defaultMessage: "Clear selected date"
  })))))));
};
exports.FlyoutBody = FlyoutBody;