"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicyListPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactRouterDom = require("react-router-dom");
var _services = require("../../../../../../common/services");
var _constants = require("../../../constants");
var _hooks = require("../../../hooks");
var _components = require("../../../components");
var _components2 = require("../../../../../components");
var _components3 = require("../components");
var _components4 = require("./components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentPolicyListPage = () => {
  var _urlParams$kuery, _agentPolicyData$tota;
  (0, _hooks.useBreadcrumbs)('policies_list');
  const {
    getPath
  } = (0, _hooks.useLink)();
  const hasFleetAllAgentPoliciesPrivileges = (0, _hooks.useAuthz)().fleet.allAgentPolicies;
  const {
    agents: {
      enabled: isFleetEnabled
    }
  } = (0, _hooks.useConfig)();

  // Table and search states
  const {
    urlParams,
    toUrlParams
  } = (0, _hooks.useUrlParams)();
  const [search, setSearch] = (0, _react.useState)(Array.isArray(urlParams.kuery) ? urlParams.kuery[urlParams.kuery.length - 1] : (_urlParams$kuery = urlParams.kuery) !== null && _urlParams$kuery !== void 0 ? _urlParams$kuery : '');
  const {
    pagination,
    pageSizeOptions,
    setPagination
  } = (0, _hooks.usePagination)();
  const {
    sorting,
    setSorting
  } = (0, _hooks.useSorting)({
    field: 'updated_at',
    direction: 'desc'
  });
  const history = (0, _reactRouterDom.useHistory)();
  const isCreateAgentPolicyFlyoutOpen = ('create' in urlParams);
  const setIsCreateAgentPolicyFlyoutOpen = (0, _react.useCallback)(isOpen => {
    if (isOpen !== isCreateAgentPolicyFlyoutOpen) {
      if (isOpen) {
        history.push(`${getPath('policies_list')}?${toUrlParams({
          ...urlParams,
          create: null
        })}`);
      } else {
        const {
          create,
          ...params
        } = urlParams;
        history.push(`${getPath('policies_list')}?${toUrlParams(params)}`);
      }
    }
  }, [getPath, history, isCreateAgentPolicyFlyoutOpen, toUrlParams, urlParams]);

  // Fetch agent policies
  const {
    isLoading,
    data: agentPolicyData,
    refetch: resendRequest
  } = (0, _hooks.useGetAgentPoliciesQuery)({
    page: pagination.currentPage,
    perPage: pagination.pageSize,
    sortField: sorting === null || sorting === void 0 ? void 0 : sorting.field,
    sortOrder: sorting === null || sorting === void 0 ? void 0 : sorting.direction,
    kuery: search,
    full: true
  });

  // Some policies retrieved, set up table props
  const columns = (0, _react.useMemo)(() => {
    const cols = [{
      field: 'name',
      sortable: true,
      name: _i18n.i18n.translate('xpack.fleet.agentPolicyList.nameColumnTitle', {
        defaultMessage: 'Name'
      }),
      width: '35%',
      render: (name, agentPolicy) => /*#__PURE__*/_react.default.createElement(_components2.AgentPolicySummaryLine, {
        policy: agentPolicy,
        withDescription: true
      })
    }, {
      field: 'updated_at',
      sortable: true,
      name: _i18n.i18n.translate('xpack.fleet.agentPolicyList.updatedOnColumnTitle', {
        defaultMessage: 'Last updated on'
      }),
      render: date => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
        value: date,
        year: "numeric",
        month: "short",
        day: "2-digit"
      })
    }, {
      field: 'agents',
      name: _i18n.i18n.translate('xpack.fleet.agentPolicyList.agentsColumnTitle', {
        defaultMessage: 'Unprivileged / Privileged'
      }),
      dataType: 'number',
      render: (agents, agentPolicy) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "row",
        gutterSize: "xs",
        justifyContent: "flexEnd"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentPolicyList.agentsColumn.unprivilegedAgentsTooltip",
          defaultMessage: "Unprivileged agents"
        })
      }, /*#__PURE__*/_react.default.createElement(_components3.LinkedAgentCount, {
        count: agentPolicy.unprivileged_agents || 0,
        agentPolicyId: agentPolicy.id,
        showAgentText: false,
        privilegeMode: "unprivileged"
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, "/"), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentPolicyList.agentsColumn.privilegedAgentsTooltip",
          defaultMessage: "Privileged agents"
        })
      }, /*#__PURE__*/_react.default.createElement(_components3.LinkedAgentCount, {
        count: agents - (agentPolicy.unprivileged_agents || 0),
        agentPolicyId: agentPolicy.id,
        showAgentText: false,
        privilegeMode: "privileged"
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyList.agentsColumn.totalAgentsTooltipWrapper",
        defaultMessage: "({message})",
        values: {
          message: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
            content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.fleet.agentPolicyList.agentsColumn.totalAgentsTooltip",
              defaultMessage: "Total agents"
            })
          }, /*#__PURE__*/_react.default.createElement(_components3.LinkedAgentCount, {
            count: agents,
            agentPolicyId: agentPolicy.id,
            showAgentText: false
          }))
        }
      }))), (0, _services.getRootIntegrations)(agentPolicy.package_policies || []).length > 0 && (agentPolicy.unprivileged_agents || 0) > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        type: "warning",
        color: "warning",
        content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentPolicyList.agentsColumn.containsUnprivilegedAgentsWarning",
          defaultMessage: "This agent policy contains integrations that require Elastic Agents to have root privileges. Some enrolled agents are running in unprivileged mode."
        })
      })))
    }, {
      field: 'package_policies',
      name: _i18n.i18n.translate('xpack.fleet.agentPolicyList.packagePoliciesCountColumnTitle', {
        defaultMessage: 'Integrations'
      }),
      dataType: 'number',
      render: packagePolicies => packagePolicies ? packagePolicies.length : 0
    }, {
      field: 'actions',
      name: _i18n.i18n.translate('xpack.fleet.agentPolicyList.actionsColumnTitle', {
        defaultMessage: 'Actions'
      }),
      actions: [{
        render: agentPolicy => /*#__PURE__*/_react.default.createElement(_components3.AgentPolicyActionMenu, {
          agentPolicy: agentPolicy,
          onCopySuccess: () => resendRequest()
        })
      }]
    }];

    // If Fleet is not enabled, then remove the `agents` column
    if (!isFleetEnabled) {
      return cols.filter(col => 'field' in col ? col.field !== 'agents' : true);
    }
    return cols;
  }, [isFleetEnabled, resendRequest]);
  const createAgentPolicyButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "plusInCircle",
    isDisabled: !hasFleetAllAgentPoliciesPrivileges,
    onClick: () => setIsCreateAgentPolicyFlyoutOpen(true),
    "data-test-subj": "createAgentPolicyButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicyList.addButton",
    defaultMessage: "Create agent policy"
  })), [hasFleetAllAgentPoliciesPrivileges, setIsCreateAgentPolicyFlyoutOpen]);
  const emptyStateCreateAgentPolicyButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "plusInCircle",
    isDisabled: !hasFleetAllAgentPoliciesPrivileges,
    onClick: () => setIsCreateAgentPolicyFlyoutOpen(true),
    "data-test-subj": "emptyPromptCreateAgentPolicyButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicyList.addButton",
    defaultMessage: "Create agent policy"
  })), [hasFleetAllAgentPoliciesPrivileges, setIsCreateAgentPolicyFlyoutOpen]);
  const emptyPrompt = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyList.noAgentPoliciesPrompt",
      defaultMessage: "No agent policies"
    })),
    actions: emptyStateCreateAgentPolicyButton
  }), [emptyStateCreateAgentPolicyButton]);
  const onTableChange = criteria => {
    const newPagination = {
      ...pagination,
      currentPage: criteria.page.index + 1,
      pageSize: criteria.page.size
    };
    setPagination(newPagination);
    setSorting(criteria.sort);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isCreateAgentPolicyFlyoutOpen ? /*#__PURE__*/_react.default.createElement(_components4.CreateAgentPolicyFlyout, {
    onClose: () => {
      setIsCreateAgentPolicyFlyoutOpen(false);
      resendRequest();
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: 'center',
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 4
  }, /*#__PURE__*/_react.default.createElement(_components.SearchBar, {
    value: search,
    indexPattern: _constants.INGEST_SAVED_OBJECT_INDEX,
    fieldPrefix: _constants.AGENT_POLICY_SAVED_OBJECT_TYPE,
    onChange: newSearch => {
      setPagination({
        ...pagination,
        currentPage: 1
      });
      setSearch(newSearch);
    },
    dataTestSubj: "agentPolicyList.queryInput"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    iconType: "refresh",
    onClick: () => resendRequest()
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicyList.reloadAgentPoliciesButtonText",
    defaultMessage: "Reload"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, createAgentPolicyButton)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    loading: isLoading,
    noItemsMessage: isLoading ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyList.loadingAgentPoliciesMessage",
      defaultMessage: "Loading agent policies\u2026"
    }) : !search.trim() && ((_agentPolicyData$tota = agentPolicyData === null || agentPolicyData === void 0 ? void 0 : agentPolicyData.total) !== null && _agentPolicyData$tota !== void 0 ? _agentPolicyData$tota : 0) === 0 ? emptyPrompt : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyList.noFilteredAgentPoliciesPrompt",
      defaultMessage: "No agent policies found. {clearFiltersLink}",
      values: {
        clearFiltersLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: () => setSearch('')
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentPolicyList.clearFiltersLinkText",
          defaultMessage: "Clear filters"
        }))
      }
    }),
    items: agentPolicyData ? agentPolicyData.items : [],
    itemId: "id",
    columns: columns,
    pagination: {
      pageIndex: pagination.currentPage - 1,
      pageSize: pagination.pageSize,
      totalItemCount: agentPolicyData ? agentPolicyData.total : 0,
      pageSizeOptions
    },
    sorting: {
      sort: sorting
    },
    onChange: onTableChange
  }));
};
exports.AgentPolicyListPage = AgentPolicyListPage;