"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAgentless = void 0;
exports.useSetupTechnology = useSetupTechnology;
var _react = require("react");
var _services = require("../../../../../services");
var _types = require("../../../../../types");
var _hooks = require("../../../../../hooks");
var _components = require("../../components");
var _constants = require("../../../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAgentless = () => {
  const {
    agentless: agentlessExperimentalFeatureEnabled
  } = _services.ExperimentalFeaturesService.get();
  const {
    cloud
  } = (0, _hooks.useStartServices)();
  const isServerless = !!(cloud !== null && cloud !== void 0 && cloud.isServerlessEnabled);
  const isAgentlessEnabled = agentlessExperimentalFeatureEnabled && isServerless;
  const isAgentlessAgentPolicy = agentPolicy => {
    if (!agentPolicy) return false;
    return isAgentlessEnabled && ((agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.id) === _constants.AGENTLESS_POLICY_ID || !!(agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.supports_agentless));
  };

  // When an integration has at least a policy template enabled for agentless
  const isAgentlessIntegration = packageInfo => {
    if (isAgentlessEnabled && packageInfo !== null && packageInfo !== void 0 && packageInfo.policy_templates && (packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.policy_templates.length) > 0 && !!(packageInfo !== null && packageInfo !== void 0 && packageInfo.policy_templates.find(policyTemplate => {
      var _policyTemplate$deplo;
      return (policyTemplate === null || policyTemplate === void 0 ? void 0 : (_policyTemplate$deplo = policyTemplate.deployment_modes) === null || _policyTemplate$deplo === void 0 ? void 0 : _policyTemplate$deplo.agentless.enabled) === true;
    }))) {
      return true;
    }
    return false;
  };

  // TODO: remove this check when CSPM implements the above flag and rely only on `isAgentlessIntegration`
  const isAgentlessPackagePolicy = packagePolicy => {
    return isAgentlessEnabled && packagePolicy.policy_ids.includes(_constants.AGENTLESS_POLICY_ID);
  };
  return {
    isAgentlessEnabled,
    isAgentlessAgentPolicy,
    isAgentlessIntegration,
    isAgentlessPackagePolicy
  };
};
exports.useAgentless = useAgentless;
function useSetupTechnology({
  updateNewAgentPolicy,
  newAgentPolicy,
  updateAgentPolicies,
  setSelectedPolicyTab,
  packageInfo
}) {
  const {
    isAgentlessEnabled,
    isAgentlessIntegration
  } = useAgentless();
  const [selectedSetupTechnology, setSelectedSetupTechnology] = (0, _react.useState)(_types.SetupTechnology.AGENT_BASED);
  const [agentlessPolicy, setAgentlessPolicy] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    if (isAgentlessEnabled && packageInfo && isAgentlessIntegration(packageInfo)) {
      setSelectedSetupTechnology(_types.SetupTechnology.AGENTLESS);
    }
  }, [isAgentlessEnabled, isAgentlessIntegration, packageInfo]);
  (0, _react.useEffect)(() => {
    const fetchAgentlessPolicy = async () => {
      const {
        data,
        error
      } = await (0, _hooks.sendGetOneAgentPolicy)(_constants.AGENTLESS_POLICY_ID);
      const isAgentlessAvailable = !error && data && data.item;
      if (isAgentlessAvailable) {
        setAgentlessPolicy(data.item);
      }
    };
    if (isAgentlessEnabled) {
      fetchAgentlessPolicy();
    }
  }, [isAgentlessEnabled]);
  const handleSetupTechnologyChange = (0, _react.useCallback)(setupTechnology => {
    if (!isAgentlessEnabled || setupTechnology === selectedSetupTechnology) {
      return;
    }
    if (setupTechnology === _types.SetupTechnology.AGENTLESS) {
      if (agentlessPolicy) {
        updateAgentPolicies([agentlessPolicy]);
        setSelectedPolicyTab(_components.SelectedPolicyTab.EXISTING);
      }
    } else if (setupTechnology === _types.SetupTechnology.AGENT_BASED) {
      updateNewAgentPolicy(newAgentPolicy);
      setSelectedPolicyTab(_components.SelectedPolicyTab.NEW);
      updateAgentPolicies([]);
    }
    setSelectedSetupTechnology(setupTechnology);
  }, [isAgentlessEnabled, selectedSetupTechnology, agentlessPolicy, updateAgentPolicies, setSelectedPolicyTab, updateNewAgentPolicy, newAgentPolicy]);
  return {
    handleSetupTechnologyChange,
    agentlessPolicy,
    selectedSetupTechnology
  };
}