"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PostInstallCloudFormationModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactQuery = require("@tanstack/react-query");
var _hooks = require("../../../../../../../../components/agent_enrollment_flyout/hooks");
var _hooks2 = require("../../../../../../hooks");
var _cloud_security_posture = require("../../../../../../../../components/cloud_security_posture");
var _services = require("../../../../../../../../components/cloud_security_posture/services");
var _hooks3 = require("../../../../../../../../components/cloud_security_posture/hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PostInstallCloudFormationModal = ({
  onConfirm,
  onCancel,
  agentPolicy,
  packagePolicy
}) => {
  var _apiKeysData$data, _apiKeysData$data$ite;
  const {
    data: apiKeysData,
    isLoading
  } = (0, _reactQuery.useQuery)(['cloudFormationApiKeys'], () => (0, _hooks2.sendGetEnrollmentAPIKeys)({
    page: 1,
    perPage: 1,
    kuery: `policy_id:${agentPolicy.id}`
  }));
  const {
    agentPolicyWithPackagePolicies
  } = (0, _hooks.useAgentPolicyWithPackagePolicies)(agentPolicy.id);
  const {
    fleetServerHost
  } = (0, _hooks2.useFleetServerHostsForPolicy)(agentPolicyWithPackagePolicies);
  const cloudFormationProps = (0, _services.getCloudFormationPropsFromPackagePolicy)(packagePolicy);
  const {
    cloudFormationUrl,
    error,
    isError
  } = (0, _hooks3.useCreateCloudFormationUrl)({
    enrollmentAPIKey: apiKeysData === null || apiKeysData === void 0 ? void 0 : (_apiKeysData$data = apiKeysData.data) === null || _apiKeysData$data === void 0 ? void 0 : (_apiKeysData$data$ite = _apiKeysData$data.items[0]) === null || _apiKeysData$data$ite === void 0 ? void 0 : _apiKeysData$data$ite.api_key,
    cloudFormationProps,
    fleetServerHost
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "data-test-subj": "postInstallCloudFormationModal",
    onClose: onCancel
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    "data-test-subj": "confirmCloudFormationModalTitleText"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicy.postInstallCloudFormationModalTitle",
    defaultMessage: "CloudFormation deployment"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_cloud_security_posture.CloudFormationGuide, {
    awsAccountType: cloudFormationProps.awsAccountType
  }), error && isError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: error,
    color: "danger",
    iconType: "error"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "confirmCloudFormationModalCancelButton",
    onClick: onCancel
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicy.postInstallCloudFormationModal.cancelButton",
    defaultMessage: "Launch CloudFormation later"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "confirmCloudFormationModalConfirmButton",
    onClick: () => {
      window.open(cloudFormationUrl);
      onConfirm();
    },
    fill: true,
    color: "primary",
    isLoading: isLoading,
    isDisabled: isError
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicy.postInstallCloudFormationModalConfirmButtonLabel",
    defaultMessage: "Launch CloudFormation"
  }))));
};
exports.PostInstallCloudFormationModal = PostInstallCloudFormationModal;