"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_AGENT_POLICY_ID = exports.DEFAULT_AGENT_POLICY = void 0;
exports.useGetAgentPolicyOrDefault = useGetAgentPolicyOrDefault;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _generate_new_agent_policy = require("../../../../../../../../common/services/generate_new_agent_policy");
var _hooks = require("../../../../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_AGENT_POLICY_ID = exports.DEFAULT_AGENT_POLICY_ID = 'fleet-first-agent-policy';
const DEFAULT_AGENT_POLICY = exports.DEFAULT_AGENT_POLICY = Object.freeze((0, _generate_new_agent_policy.generateNewAgentPolicyWithDefaults)({
  id: DEFAULT_AGENT_POLICY_ID,
  name: _i18n.i18n.translate('xpack.fleet.createPackagePolicy.firstAgentPolicyNameText', {
    defaultMessage: 'My first agent policy'
  })
}));
const sendGetAgentPolicy = async agentPolicyId => {
  var _result;
  let result;
  let error;
  try {
    result = await (0, _hooks.sendGetOneAgentPolicy)(agentPolicyId);
    if (result.error) {
      error = result.error;
    }
  } catch (e) {
    error = e;
  }
  if (error && error.statusCode !== 404) {
    return {
      error
    };
  }
  return {
    data: (_result = result) === null || _result === void 0 ? void 0 : _result.data
  };
};
const sendCreateDefaultAgentPolicy = _hooks.sendCreateAgentPolicy.bind(null, DEFAULT_AGENT_POLICY);
function useGetAgentPolicyOrDefault(agentPolicyIdIn) {
  const [result, setResult] = (0, _react.useState)({
    isLoading: true
  });
  (0, _react.useEffect)(() => {
    const getAgentPolicyOrDefault = async () => {
      var _apiKeysData$items;
      const agentPolicyId = agentPolicyIdIn || DEFAULT_AGENT_POLICY_ID;
      const {
        data: agentPolicyData,
        error: getError
      } = await sendGetAgentPolicy(agentPolicyId);
      const existingAgentPolicy = agentPolicyData === null || agentPolicyData === void 0 ? void 0 : agentPolicyData.item;
      if (agentPolicyIdIn && !existingAgentPolicy) {
        setResult({
          isLoading: false,
          error: new Error(`Agent policy ${agentPolicyId} not found`)
        });
        return;
      }
      let createdAgentPolicy;
      if (getError) {
        setResult({
          isLoading: false,
          error: getError
        });
        return;
      }
      if (!existingAgentPolicy) {
        const {
          data: createdAgentPolicyData,
          error: createError
        } = await sendCreateDefaultAgentPolicy();
        if (createError) {
          setResult({
            isLoading: false,
            error: createError
          });
          return;
        }
        createdAgentPolicy = createdAgentPolicyData.item;
      }
      const agentPolicy = existingAgentPolicy || createdAgentPolicy;
      const {
        data: apiKeysData,
        error: apiKeysError
      } = await (0, _hooks.sendGetEnrollmentAPIKeys)({
        page: 1,
        perPage: 1,
        kuery: `policy_id:${agentPolicyId}`
      });
      if (apiKeysError) {
        setResult({
          isLoading: false,
          error: apiKeysError
        });
        return;
      }
      if (!apiKeysData || !((_apiKeysData$items = apiKeysData.items) !== null && _apiKeysData$items !== void 0 && _apiKeysData$items.length)) {
        setResult({
          isLoading: false,
          error: new Error(`No enrollment API key found for policy ${agentPolicyId}`)
        });
        return;
      }
      const enrollmentAPIKey = apiKeysData.items[0];
      setResult({
        isLoading: false,
        created: !!createdAgentPolicy,
        agentPolicy,
        enrollmentAPIKey
      });
    };
    getAgentPolicyOrDefault();
  }, [agentPolicyIdIn]);
  return result;
}